/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.curator.test.TestingServer;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriver;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.SupplierWithException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ZooKeeperLeaderRetrievalConnectionHandlingTest
extends TestLogger {
    private TestingServer testingServer;
    private CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;
    private CuratorFramework zooKeeperClient;
    @Rule
    public final TestingFatalErrorHandlerResource fatalErrorHandlerResource = new TestingFatalErrorHandlerResource();

    @Before
    public void before() throws Exception {
        this.testingServer = new TestingServer();
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.testingServer.getConnectString());
        this.curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)config, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
        this.zooKeeperClient = this.curatorFrameworkWrapper.asCuratorFramework();
        this.zooKeeperClient.blockUntilConnected();
    }

    @After
    public void after() throws Exception {
        this.closeTestServer();
        if (this.curatorFrameworkWrapper != null) {
            this.curatorFrameworkWrapper.close();
            this.curatorFrameworkWrapper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionSuspendedHandlingDuringInitialization() throws Exception {
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1);
        try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;){
            leaderRetrievalDriver = ZooKeeperUtils.createLeaderRetrievalDriverFactory((CuratorFramework)this.zooKeeperClient).createLeaderRetrievalDriver((LeaderRetrievalEventHandler)queueLeaderElectionListener, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
            CompletableFuture<String> firstAddress = queueLeaderElectionListener.next(Duration.ofMillis(50L));
            MatcherAssert.assertThat((String)"No results are expected, yet, since no leader was elected.", firstAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            this.restartTestServer();
            CompletableFuture<String> secondAddress = queueLeaderElectionListener.next();
            MatcherAssert.assertThat((String)"The next result must not be missing.", secondAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((String)"The next result is expected to be null.", (Object)secondAddress.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionSuspendedHandling() throws Exception {
        String retrievalPath = "/testConnectionSuspendedHandling";
        String leaderAddress = "localhost";
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1);
        try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;){
            leaderRetrievalDriver = new ZooKeeperLeaderRetrievalDriver(this.zooKeeperClient, "/testConnectionSuspendedHandling", (LeaderRetrievalEventHandler)queueLeaderElectionListener, ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_SUSPENDED_CONNECTION, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
            this.writeLeaderInformationToZooKeeper(leaderRetrievalDriver.getConnectionInformationPath(), "localhost", UUID.randomUUID());
            CompletableFuture<String> firstAddress = queueLeaderElectionListener.next();
            MatcherAssert.assertThat((String)"The first result is expected to be the initially set leader address.", (Object)firstAddress.get(), (Matcher)CoreMatchers.is((Object)"localhost"));
            this.restartTestServer();
            CompletableFuture<String> secondAddress = queueLeaderElectionListener.next();
            MatcherAssert.assertThat((String)"The next result must not be missing.", secondAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((String)"The next result is expected to be null.", (Object)secondAddress.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuspendedConnectionDoesNotClearLeaderInformationIfClearanceOnLostConnection() throws Exception {
        String retrievalPath = "/testConnectionSuspendedHandling";
        String leaderAddress = "localhost";
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1);
        try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;){
            leaderRetrievalDriver = new ZooKeeperLeaderRetrievalDriver(this.zooKeeperClient, "/testConnectionSuspendedHandling", (LeaderRetrievalEventHandler)queueLeaderElectionListener, ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_LOST_CONNECTION, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
            this.writeLeaderInformationToZooKeeper(leaderRetrievalDriver.getConnectionInformationPath(), "localhost", UUID.randomUUID());
            CompletableFuture<String> firstAddress = queueLeaderElectionListener.next();
            MatcherAssert.assertThat((String)"The first result is expected to be the initially set leader address.", (Object)firstAddress.get(), (Matcher)CoreMatchers.is((Object)"localhost"));
            this.closeTestServer();
            MatcherAssert.assertThat(queueLeaderElectionListener.next(Duration.ofMillis(100L)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameLeaderAfterReconnectTriggersListenerNotification() throws Exception {
        String retrievalPath = "/testSameLeaderAfterReconnectTriggersListenerNotification";
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1);
        try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;){
            leaderRetrievalDriver = new ZooKeeperLeaderRetrievalDriver(this.zooKeeperClient, "/testSameLeaderAfterReconnectTriggersListenerNotification", (LeaderRetrievalEventHandler)queueLeaderElectionListener, ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_SUSPENDED_CONNECTION, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
            String leaderAddress = "foobar";
            UUID sessionId = UUID.randomUUID();
            this.writeLeaderInformationToZooKeeper(leaderRetrievalDriver.getConnectionInformationPath(), "foobar", sessionId);
            queueLeaderElectionListener.next();
            this.testingServer.stop();
            CompletableFuture<String> connectionSuspension = queueLeaderElectionListener.next();
            connectionSuspension.join();
            this.testingServer.restart();
            CompletableFuture<String> connectionReconnect = queueLeaderElectionListener.next();
            MatcherAssert.assertThat((Object)connectionReconnect.get(), (Matcher)CoreMatchers.is((Object)"foobar"));
        }
    }

    private void writeLeaderInformationToZooKeeper(String retrievalPath, String leaderAddress, UUID sessionId) throws Exception {
        byte[] data = this.createLeaderInformation(leaderAddress, sessionId);
        if (this.zooKeeperClient.checkExists().forPath(retrievalPath) != null) {
            this.zooKeeperClient.setData().forPath(retrievalPath, data);
        } else {
            this.zooKeeperClient.create().creatingParentsIfNeeded().forPath(retrievalPath, data);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] createLeaderInformation(String leaderAddress, UUID sessionId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewLeaderAfterReconnectTriggersListenerNotification() throws Exception {
        String retrievalPath = "/testNewLeaderAfterReconnectTriggersListenerNotification";
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1);
        try (ZooKeeperLeaderRetrievalDriver leaderRetrievalDriver = null;){
            leaderRetrievalDriver = new ZooKeeperLeaderRetrievalDriver(this.zooKeeperClient, "/testNewLeaderAfterReconnectTriggersListenerNotification", (LeaderRetrievalEventHandler)queueLeaderElectionListener, ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_SUSPENDED_CONNECTION, (FatalErrorHandler)this.fatalErrorHandlerResource.getFatalErrorHandler());
            String leaderAddress = "foobar";
            UUID sessionId = UUID.randomUUID();
            this.writeLeaderInformationToZooKeeper(leaderRetrievalDriver.getConnectionInformationPath(), "foobar", sessionId);
            queueLeaderElectionListener.next();
            this.testingServer.stop();
            CompletableFuture<String> connectionSuspension = queueLeaderElectionListener.next();
            connectionSuspension.join();
            this.testingServer.restart();
            String newLeaderAddress = "barfoo";
            UUID newSessionId = UUID.randomUUID();
            this.writeLeaderInformationToZooKeeper(leaderRetrievalDriver.getConnectionInformationPath(), "barfoo", newSessionId);
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
                CompletableFuture<String> afterConnectionReconnect = queueLeaderElectionListener.next();
                return afterConnectionReconnect.get().equals("barfoo");
            }), Deadline.fromNow((Duration)Duration.ofSeconds(30L)));
        }
    }

    private void closeTestServer() throws IOException {
        if (this.testingServer != null) {
            this.testingServer.close();
            this.testingServer = null;
        }
    }

    private void restartTestServer() throws Exception {
        ((TestingServer)Preconditions.checkNotNull((Object)this.testingServer, (String)"TestingServer needs to be initialized.")).restart();
    }

    private static class QueueLeaderElectionListener
    implements LeaderRetrievalEventHandler {
        private final BlockingQueue<CompletableFuture<String>> queue;

        public QueueLeaderElectionListener(int expectedCalls) {
            this.queue = new ArrayBlockingQueue<CompletableFuture<String>>(expectedCalls);
        }

        public void notifyLeaderAddress(LeaderInformation leaderInformation) {
            String leaderAddress = leaderInformation.getLeaderAddress();
            try {
                this.queue.put(CompletableFuture.completedFuture(leaderAddress));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public CompletableFuture<String> next() {
            return (CompletableFuture)Preconditions.checkNotNull(this.next(null));
        }

        @Nullable
        public CompletableFuture<String> next(@Nullable Duration timeout) {
            try {
                if (timeout == null) {
                    return this.queue.take();
                }
                return this.queue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

