/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPool;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public final class SlotPoolTestUtils {
    private SlotPoolTestUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    public static TaskManagerGateway createTaskManagerGateway(@Nullable TaskExecutorGateway taskExecutorGateway) {
        return new RpcTaskManagerGateway((TaskExecutorGateway)(taskExecutorGateway == null ? new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway() : taskExecutorGateway), JobMasterId.generate());
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(DeclarativeSlotPool slotPool, Collection<? extends SlotOffer> slotOffers) {
        return SlotPoolTestUtils.offerSlots(slotPool, slotOffers, SlotPoolTestUtils.createTaskManagerGateway(null));
    }

    @Nonnull
    public static Collection<SlotOffer> offerSlots(DeclarativeSlotPool slotPool, Collection<? extends SlotOffer> slotOffers, TaskManagerGateway taskManagerGateway) {
        return slotPool.offerSlots(slotOffers, (TaskManagerLocation)new LocalTaskManagerLocation(), taskManagerGateway, 0L);
    }
}

