/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultExecutionDeploymentTrackerTest
extends TestLogger {
    @Test
    public void testStartTracking() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = new ExecutionAttemptID();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        Assert.assertThat((Object)tracker.getExecutionsOn(resourceId1), (Matcher)Matchers.hasEntry((Object)attemptId1, (Object)ExecutionDeploymentState.PENDING));
        tracker.completeDeploymentOf(attemptId1);
        Assert.assertThat((Object)tracker.getExecutionsOn(resourceId1), (Matcher)Matchers.hasEntry((Object)attemptId1, (Object)ExecutionDeploymentState.DEPLOYED));
    }

    @Test
    public void testStopTrackingCompletedDeployment() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = new ExecutionAttemptID();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.completeDeploymentOf(attemptId1);
        tracker.stopTrackingDeploymentOf(attemptId1);
        Assert.assertThat(tracker.getExecutionsOn(resourceId1).entrySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void testStopTrackingPendingDeployment() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = new ExecutionAttemptID();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.stopTrackingDeploymentOf(attemptId1);
        Assert.assertThat(tracker.getExecutionsOn(resourceId1).entrySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void testStopTrackingDoesNotAffectOtherIds() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId1 = new ExecutionAttemptID();
        ResourceID resourceId1 = ResourceID.generate();
        tracker.startTrackingPendingDeploymentOf(attemptId1, resourceId1);
        tracker.completeDeploymentOf(attemptId1);
        tracker.stopTrackingDeploymentOf(new ExecutionAttemptID());
        Assert.assertThat((Object)tracker.getExecutionsOn(resourceId1), (Matcher)Matchers.hasKey((Object)attemptId1));
    }

    @Test
    public void testCompleteDeploymentUnknownExecutionDoesNotThrowException() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        tracker.completeDeploymentOf(new ExecutionAttemptID());
    }

    @Test
    public void testStopTrackingUnknownExecutionDoesNotThrowException() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        ExecutionAttemptID attemptId2 = new ExecutionAttemptID();
        tracker.stopTrackingDeploymentOf(attemptId2);
    }

    @Test
    public void testGetExecutionsReturnsEmptySetForUnknownHost() {
        DefaultExecutionDeploymentTracker tracker = new DefaultExecutionDeploymentTracker();
        Assert.assertThat(tracker.getExecutionsOn(ResourceID.generate()).entrySet(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.empty()));
    }
}

