/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.util.Preconditions;

public class TestSingleInputGate {
    protected final SingleInputGate inputGate;
    protected final TestInputChannel[] inputChannels;

    public TestSingleInputGate(int numberOfInputChannels, int gateIndex, boolean initialize) {
        Preconditions.checkArgument((numberOfInputChannels >= 1 ? 1 : 0) != 0);
        this.inputGate = new SingleInputGateBuilder().setNumberOfChannels(numberOfInputChannels).setSingleInputGateIndex(gateIndex).build();
        this.inputChannels = new TestInputChannel[numberOfInputChannels];
        if (initialize) {
            for (int i = 0; i < numberOfInputChannels; ++i) {
                this.inputChannels[i] = new TestInputChannel(this.inputGate, i);
            }
            this.inputGate.setInputChannels((InputChannel[])this.inputChannels);
        }
    }

    public SingleInputGate getInputGate() {
        return this.inputGate;
    }
}

