/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.BufferWithChannel;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.runtime.io.network.partition.PartitionedFileWriter;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public enum PartitionTestUtils {


    public static ResultPartition createPartition() {
        return PartitionTestUtils.createPartition(ResultPartitionType.PIPELINED_BOUNDED);
    }

    public static ResultPartition createPartition(ResultPartitionType type) {
        return new ResultPartitionBuilder().setResultPartitionType(type).build();
    }

    public static ResultPartition createPartition(ResultPartitionType type, FileChannelManager channelManager) {
        return new ResultPartitionBuilder().setResultPartitionType(type).setFileChannelManager(channelManager).build();
    }

    public static ResultPartition createPartition(ResultPartitionType type, FileChannelManager channelManager, boolean compressionEnabled, int networkBufferSize) {
        return new ResultPartitionBuilder().setResultPartitionType(type).setFileChannelManager(channelManager).setBlockingShuffleCompressionEnabled(compressionEnabled).setNetworkBufferSize(networkBufferSize).build();
    }

    public static ResultPartition createPartition(NettyShuffleEnvironment environment, ResultPartitionType partitionType, int numChannels) {
        return new ResultPartitionBuilder().setResultPartitionManager(environment.getResultPartitionManager()).setupBufferPoolFactoryFromNettyShuffleEnvironment(environment).setResultPartitionType(partitionType).setNumberOfSubpartitions(numChannels).build();
    }

    public static ResultPartition createPartition(NettyShuffleEnvironment environment, FileChannelManager channelManager, ResultPartitionType partitionType, int numChannels) {
        return new ResultPartitionBuilder().setResultPartitionManager(environment.getResultPartitionManager()).setupBufferPoolFactoryFromNettyShuffleEnvironment(environment).setFileChannelManager(channelManager).setResultPartitionType(partitionType).setNumberOfSubpartitions(numChannels).build();
    }

    public static ResultSubpartitionView createView(ResultSubpartition subpartition, BufferAvailabilityListener listener) throws IOException {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition parent = subpartition.parent;
        partitionManager.registerResultPartition(parent);
        return partitionManager.createSubpartitionView(parent.partitionId, 0, listener);
    }

    static void verifyCreateSubpartitionViewThrowsException(ResultPartitionProvider partitionManager, ResultPartitionID partitionId) throws IOException {
        try {
            partitionManager.createSubpartitionView(partitionId, 0, (BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"Should throw a PartitionNotFoundException.");
        }
        catch (PartitionNotFoundException notFound) {
            Assert.assertThat((Object)partitionId, (Matcher)Matchers.is((Object)notFound.getPartitionId()));
        }
    }

    public static ResultPartitionDeploymentDescriptor createPartitionDeploymentDescriptor(ResultPartitionType partitionType) {
        NettyShuffleDescriptor shuffleDescriptor = NettyShuffleDescriptorBuilder.newBuilder().buildLocal();
        PartitionDescriptor partitionDescriptor = PartitionDescriptorBuilder.newBuilder().setPartitionId(shuffleDescriptor.getResultPartitionID().getPartitionId()).setPartitionType(partitionType).build();
        return new ResultPartitionDeploymentDescriptor(partitionDescriptor, (ShuffleDescriptor)shuffleDescriptor, 1, true);
    }

    public static PartitionedFile createPartitionedFile(String basePath, int numSubpartitions, int numBuffersPerSubpartition, int bufferSize, byte[] dataBytes) throws Exception {
        ArrayList<BufferWithChannel> buffers = new ArrayList<BufferWithChannel>();
        for (int i = 0; i < numSubpartitions; ++i) {
            for (int j = 0; j < numBuffersPerSubpartition; ++j) {
                Buffer.DataType dataType = j == numBuffersPerSubpartition - 1 ? Buffer.DataType.EVENT_BUFFER : Buffer.DataType.DATA_BUFFER;
                MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize);
                segment.put(0, dataBytes);
                NetworkBuffer buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, dataType, bufferSize);
                buffers.add(new BufferWithChannel((Buffer)buffer, i));
            }
        }
        PartitionedFileWriter fileWriter = new PartitionedFileWriter(numSubpartitions, 1024, basePath);
        fileWriter.startNewRegion(false);
        fileWriter.writeBuffers(buffers);
        return fileWriter.finish();
    }
}

