/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.netty.CreditBasedSequenceNumberingViewReader;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.NoOpResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Assert;
import org.junit.Test;

public class CreditBasedSequenceNumberingViewReaderTest {
    @Test
    public void testResumeConsumption() throws Exception {
        int numCredits = 2;
        CreditBasedSequenceNumberingViewReader reader1 = this.createNetworkSequenceViewReader(numCredits);
        reader1.resumeConsumption();
        Assert.assertEquals((long)numCredits, (long)reader1.getNumCreditsAvailable());
        reader1.addCredit(numCredits);
        reader1.resumeConsumption();
        Assert.assertEquals((long)(2 * numCredits), (long)reader1.getNumCreditsAvailable());
        CreditBasedSequenceNumberingViewReader reader2 = this.createNetworkSequenceViewReader(0);
        reader2.addCredit(numCredits);
        Assert.assertEquals((long)numCredits, (long)reader2.getNumCreditsAvailable());
        reader2.resumeConsumption();
        Assert.assertEquals((long)0L, (long)reader2.getNumCreditsAvailable());
    }

    @Test
    public void testNeedAnnounceBacklog() throws Exception {
        int numCredits = 2;
        CreditBasedSequenceNumberingViewReader reader1 = this.createNetworkSequenceViewReader(numCredits);
        Assert.assertFalse((boolean)reader1.needAnnounceBacklog());
        reader1.addCredit(-numCredits);
        Assert.assertFalse((boolean)reader1.needAnnounceBacklog());
        CreditBasedSequenceNumberingViewReader reader2 = this.createNetworkSequenceViewReader(0);
        Assert.assertTrue((boolean)reader2.needAnnounceBacklog());
        reader2.addCredit(numCredits);
        Assert.assertFalse((boolean)reader2.needAnnounceBacklog());
        reader2.addCredit(-numCredits);
        Assert.assertTrue((boolean)reader2.needAnnounceBacklog());
    }

    private CreditBasedSequenceNumberingViewReader createNetworkSequenceViewReader(int initialCredit) throws Exception {
        PartitionRequestQueue queue = new PartitionRequestQueue();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{queue});
        channel.close();
        CreditBasedSequenceNumberingViewReader reader = new CreditBasedSequenceNumberingViewReader(new InputChannelID(), initialCredit, queue);
        reader.requestSubpartitionView((ignored1, ignored2, ignored3) -> new NoOpResultSubpartitionView(), new ResultPartitionID(), 0);
        return reader;
    }
}

