/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.FlinkDistributionOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FlinkDistributionOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File binFolder = this.tempFolder.newFolder("bin");
        File libFolder = this.tempFolder.newFolder("lib");
        File pluginsFolder = this.tempFolder.newFolder("plugins");
        File confFolder = this.tempFolder.newFolder("conf");
        Path[] files = FlinkDistributionOverlayTest.createPaths(this.tempFolder.getRoot(), "bin/config.sh", "bin/taskmanager.sh", "lib/foo.jar", "lib/A/foo.jar", "lib/B/foo.jar", "lib/B/bar.jar", "plugins/P1/plugin1a.jar", "plugins/P1/plugin1b.jar", "plugins/P2/plugin2.jar");
        this.testConfigure(binFolder, libFolder, pluginsFolder, confFolder, files);
    }

    private void testConfigure(File binFolder, File libFolder, File pluginsFolder, File confFolder, Path[] files) throws IOException {
        ContainerSpecification containerSpecification = new ContainerSpecification();
        FlinkDistributionOverlay overlay = new FlinkDistributionOverlay(binFolder, confFolder, libFolder, pluginsFolder);
        overlay.configure(containerSpecification);
        for (Path file : files) {
            FlinkDistributionOverlayTest.checkArtifact(containerSpecification, new Path(FlinkDistributionOverlay.TARGET_ROOT, file.toString()));
        }
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        Configuration conf = new Configuration();
        File binFolder = this.tempFolder.newFolder("bin");
        File libFolder = this.tempFolder.newFolder("lib");
        File pluginsFolder = this.tempFolder.newFolder("plugins");
        File confFolder = this.tempFolder.newFolder("conf");
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.put("FLINK_BIN_DIR", binFolder.getAbsolutePath());
        map.put("FLINK_LIB_DIR", libFolder.getAbsolutePath());
        map.put("FLINK_PLUGINS_DIR", pluginsFolder.getAbsolutePath());
        map.put("FLINK_CONF_DIR", confFolder.getAbsolutePath());
        CommonTestUtils.setEnv(map);
        FlinkDistributionOverlay.Builder builder = FlinkDistributionOverlay.newBuilder().fromEnvironment(conf);
        Assert.assertEquals((Object)binFolder.getAbsolutePath(), (Object)builder.flinkBinPath.getAbsolutePath());
        Assert.assertEquals((Object)libFolder.getAbsolutePath(), (Object)builder.flinkLibPath.getAbsolutePath());
        File flinkPluginsPath = builder.flinkPluginsPath;
        Assert.assertNotNull((Object)flinkPluginsPath);
        Assert.assertEquals((Object)pluginsFolder.getAbsolutePath(), (Object)flinkPluginsPath.getAbsolutePath());
        Assert.assertEquals((Object)confFolder.getAbsolutePath(), (Object)builder.flinkConfPath.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSettingFlinkHomeEnv() throws IOException {
        ContainerSpecification containerSpecification = new ContainerSpecification();
        Configuration conf = new Configuration();
        File binFolder = this.tempFolder.newFolder("bin");
        File libFolder = this.tempFolder.newFolder("lib");
        File confFolder = this.tempFolder.newFolder("conf");
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> testEnv = new HashMap<String, String>(originalEnv);
        testEnv.put("FLINK_BIN_DIR", binFolder.getAbsolutePath());
        testEnv.put("FLINK_LIB_DIR", libFolder.getAbsolutePath());
        testEnv.put("FLINK_CONF_DIR", confFolder.getAbsolutePath());
        CommonTestUtils.setEnv(testEnv);
        try {
            FlinkDistributionOverlay flinkDistributionOverlay = FlinkDistributionOverlay.newBuilder().fromEnvironment(conf).build();
            flinkDistributionOverlay.configure(containerSpecification);
            Assert.assertEquals((Object)".", containerSpecification.getEnvironmentVariables().get("FLINK_HOME"));
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
    }

    @Test
    public void testBuilderFromEnvironmentBad() throws Exception {
        this.testBuilderFromEnvironmentBad("FLINK_BIN_DIR");
        this.testBuilderFromEnvironmentBad("FLINK_LIB_DIR");
        this.testBuilderFromEnvironmentBad("FLINK_PLUGINS_DIR");
        this.testBuilderFromEnvironmentBad("FLINK_CONF_DIR");
    }

    public void testBuilderFromEnvironmentBad(String obligatoryEnvironmentVariable) throws Exception {
        Configuration conf = new Configuration();
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.remove(obligatoryEnvironmentVariable);
        CommonTestUtils.setEnv(map);
        try {
            FlinkDistributionOverlay.Builder builder = FlinkDistributionOverlay.newBuilder().fromEnvironment(conf);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

