/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.client.SerializedJobExecutionResult;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SerializedJobExecutionResultTest
extends TestLogger {
    @Test
    public void testSerialization() throws Exception {
        ClassLoader classloader = ((Object)((Object)this)).getClass().getClassLoader();
        JobID origJobId = new JobID();
        long origTime = 65927436589267L;
        HashMap<String, SerializedValue> origMap = new HashMap<String, SerializedValue>();
        origMap.put("name1", new SerializedValue((Object)OptionalFailure.of((Object)723L)));
        origMap.put("name2", new SerializedValue((Object)OptionalFailure.of((Object)"peter")));
        origMap.put("name3", new SerializedValue((Object)OptionalFailure.ofFailure((Throwable)new ExpectedTestException())));
        SerializedJobExecutionResult result = new SerializedJobExecutionResult(origJobId, origTime, origMap);
        SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
        Assert.assertEquals((Object)origJobId, (Object)cloned.getJobId());
        Assert.assertEquals((long)origTime, (long)cloned.getNetRuntime());
        Assert.assertEquals((long)origTime, (long)cloned.getNetRuntime(TimeUnit.MILLISECONDS));
        Assert.assertEquals(origMap, (Object)cloned.getSerializedAccumulatorResults());
        JobExecutionResult jResult = result.toJobExecutionResult(classloader);
        JobExecutionResult jResultCopied = result.toJobExecutionResult(classloader);
        Assert.assertEquals((Object)origJobId, (Object)jResult.getJobID());
        Assert.assertEquals((Object)origJobId, (Object)jResultCopied.getJobID());
        Assert.assertEquals((long)origTime, (long)jResult.getNetRuntime());
        Assert.assertEquals((long)origTime, (long)jResult.getNetRuntime(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)origTime, (long)jResultCopied.getNetRuntime());
        Assert.assertEquals((long)origTime, (long)jResultCopied.getNetRuntime(TimeUnit.MILLISECONDS));
        for (Map.Entry entry : origMap.entrySet()) {
            String name = (String)entry.getKey();
            OptionalFailure value = (OptionalFailure)((SerializedValue)entry.getValue()).deserializeValue(classloader);
            if (value.isFailure()) {
                try {
                    jResult.getAccumulatorResult(name);
                    Assert.fail((String)"expected failure");
                }
                catch (FlinkRuntimeException ex) {
                    Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)ex, ExpectedTestException.class).isPresent());
                }
                try {
                    jResultCopied.getAccumulatorResult(name);
                    Assert.fail((String)"expected failure");
                }
                catch (FlinkRuntimeException ex) {
                    Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)ex, ExpectedTestException.class).isPresent());
                }
                continue;
            }
            Assert.assertEquals((Object)value.get(), (Object)jResult.getAccumulatorResult(name));
            Assert.assertEquals((Object)value.get(), (Object)jResultCopied.getAccumulatorResult(name));
        }
    }

    @Test
    public void testSerializationWithNullValues() throws Exception {
        SerializedJobExecutionResult result = new SerializedJobExecutionResult(null, 0L, null);
        SerializedJobExecutionResult cloned = (SerializedJobExecutionResult)CommonTestUtils.createCopySerializable((Serializable)result);
        Assert.assertNull((Object)cloned.getJobId());
        Assert.assertEquals((long)0L, (long)cloned.getNetRuntime());
        Assert.assertNull((Object)cloned.getSerializedAccumulatorResults());
        JobExecutionResult jResult = result.toJobExecutionResult(((Object)((Object)this)).getClass().getClassLoader());
        Assert.assertNull((Object)jResult.getJobID());
        Assert.assertTrue((boolean)jResult.getAllAccumulatorResults().isEmpty());
    }
}

