/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TaskStateSnapshotTest
extends TestLogger {
    @Test
    public void putGetSubtaskStateByOperatorID() {
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        OperatorID operatorID_1 = new OperatorID();
        OperatorID operatorID_2 = new OperatorID();
        OperatorSubtaskState operatorSubtaskState_1 = OperatorSubtaskState.builder().build();
        OperatorSubtaskState operatorSubtaskState_2 = OperatorSubtaskState.builder().build();
        OperatorSubtaskState operatorSubtaskState_1_replace = OperatorSubtaskState.builder().build();
        Assert.assertNull((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1));
        Assert.assertNull((Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_2));
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_2, operatorSubtaskState_2);
        Assert.assertEquals((Object)operatorSubtaskState_1, (Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1));
        Assert.assertEquals((Object)operatorSubtaskState_2, (Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_2));
        Assert.assertEquals((Object)operatorSubtaskState_1, (Object)taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1_replace));
        Assert.assertEquals((Object)operatorSubtaskState_1_replace, (Object)taskStateSnapshot.getSubtaskStateByOperatorID(operatorID_1));
    }

    @Test
    public void hasState() {
        Random random = new Random(66L);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        Assert.assertFalse((boolean)taskStateSnapshot.hasState());
        OperatorSubtaskState emptyOperatorSubtaskState = OperatorSubtaskState.builder().build();
        Assert.assertFalse((boolean)emptyOperatorSubtaskState.hasState());
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), emptyOperatorSubtaskState);
        Assert.assertFalse((boolean)taskStateSnapshot.hasState());
        OperatorStateHandle stateHandle = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState = OperatorSubtaskState.builder().setManagedOperatorState(stateHandle).build();
        Assert.assertTrue((boolean)nonEmptyOperatorSubtaskState.hasState());
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState);
        Assert.assertTrue((boolean)taskStateSnapshot.hasState());
    }

    @Test
    public void discardState() throws Exception {
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        OperatorID operatorID_1 = new OperatorID();
        OperatorID operatorID_2 = new OperatorID();
        OperatorSubtaskState operatorSubtaskState_1 = (OperatorSubtaskState)Mockito.mock(OperatorSubtaskState.class);
        OperatorSubtaskState operatorSubtaskState_2 = (OperatorSubtaskState)Mockito.mock(OperatorSubtaskState.class);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, operatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(operatorID_2, operatorSubtaskState_2);
        taskStateSnapshot.discardState();
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState_1)).discardState();
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState_2)).discardState();
    }

    @Test
    public void getStateSize() {
        Random random = new Random(66L);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot();
        Assert.assertEquals((long)0L, (long)taskStateSnapshot.getStateSize());
        OperatorSubtaskState emptyOperatorSubtaskState = OperatorSubtaskState.builder().build();
        Assert.assertFalse((boolean)emptyOperatorSubtaskState.hasState());
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), emptyOperatorSubtaskState);
        Assert.assertEquals((long)0L, (long)taskStateSnapshot.getStateSize());
        OperatorStateHandle stateHandle_1 = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState_1 = OperatorSubtaskState.builder().setManagedOperatorState(stateHandle_1).build();
        OperatorStateHandle stateHandle_2 = StateHandleDummyUtil.createNewOperatorStateHandle(2, random);
        OperatorSubtaskState nonEmptyOperatorSubtaskState_2 = OperatorSubtaskState.builder().setRawOperatorState(stateHandle_2).build();
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState_1);
        taskStateSnapshot.putSubtaskStateByOperatorID(new OperatorID(), nonEmptyOperatorSubtaskState_2);
        long totalSize = stateHandle_1.getStateSize() + stateHandle_2.getStateSize();
        Assert.assertEquals((long)totalSize, (long)taskStateSnapshot.getStateSize());
    }

    @Test
    public void testSizeIncludesChannelState() {
        Random random = new Random();
        InputChannelStateHandle inputChannelStateHandle = StateHandleDummyUtil.createNewInputChannelStateHandle(10, random);
        ResultSubpartitionStateHandle resultSubpartitionStateHandle = StateHandleDummyUtil.createNewResultSubpartitionStateHandle(10, random);
        TaskStateSnapshot taskStateSnapshot = new TaskStateSnapshot(Collections.singletonMap(new OperatorID(), OperatorSubtaskState.builder().setInputChannelState(StateObjectCollection.singleton((StateObject)inputChannelStateHandle)).setResultSubpartitionState(StateObjectCollection.singleton((StateObject)resultSubpartitionStateHandle)).build()));
        Assert.assertEquals((long)(inputChannelStateHandle.getStateSize() + resultSubpartitionStateHandle.getStateSize()), (long)taskStateSnapshot.getStateSize());
        Assert.assertTrue((boolean)taskStateSnapshot.hasState());
    }
}

