/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStoreUtils;
import org.apache.flink.runtime.checkpoint.TestingRetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.persistence.TestingStateHandleStore;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCompletedCheckpointStoreUtilsTest
extends TestLogger {
    private static CompletedCheckpoint createCompletedCheckpoint(long checkpointId) {
        return new CompletedCheckpoint(new JobID(), checkpointId, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation());
    }

    @Test
    public void testRetrievedCheckpointsAreOrderedChronologically() throws Exception {
        TestingRetrievableStateStorageHelper<CompletedCheckpoint> storageHelper = new TestingRetrievableStateStorageHelper<CompletedCheckpoint>();
        ArrayList<Tuple2> handles = new ArrayList<Tuple2>();
        handles.add(Tuple2.of(storageHelper.store(DefaultCompletedCheckpointStoreUtilsTest.createCompletedCheckpoint(0L)), (Object)"checkpoint-0"));
        handles.add(Tuple2.of(storageHelper.store(DefaultCompletedCheckpointStoreUtilsTest.createCompletedCheckpoint(1L)), (Object)"checkpoint-1"));
        handles.add(Tuple2.of(storageHelper.store(DefaultCompletedCheckpointStoreUtilsTest.createCompletedCheckpoint(2L)), (Object)"checkpoint-2"));
        Collections.shuffle(handles);
        TestingStateHandleStore stateHandleStore = TestingStateHandleStore.newBuilder().setGetAllSupplier(() -> handles).build();
        Collection completedCheckpoints = DefaultCompletedCheckpointStoreUtils.retrieveCompletedCheckpoints(stateHandleStore, (CheckpointStoreUtil)new SimpleCheckpointStoreUtil());
        Assert.assertEquals(Arrays.asList(0L, 1L, 2L), completedCheckpoints.stream().map(CompletedCheckpoint::getCheckpointID).collect(Collectors.toList()));
    }

    @Test
    public void testRetrievingCheckpointsFailsIfRetrievalOfAnyCheckpointFails() throws Exception {
        TestingRetrievableStateStorageHelper<CompletedCheckpoint> storageHelper = new TestingRetrievableStateStorageHelper<CompletedCheckpoint>();
        ArrayList<Tuple2> handles = new ArrayList<Tuple2>();
        handles.add(Tuple2.of(storageHelper.store(DefaultCompletedCheckpointStoreUtilsTest.createCompletedCheckpoint(0L)), (Object)"checkpoint-0"));
        handles.add(Tuple2.of(new FailingRetrievableStateHandle(), (Object)"checkpoint-1"));
        handles.add(Tuple2.of(storageHelper.store(DefaultCompletedCheckpointStoreUtilsTest.createCompletedCheckpoint(2L)), (Object)"checkpoint-2"));
        Collections.shuffle(handles);
        TestingStateHandleStore stateHandleStore = TestingStateHandleStore.newBuilder().setGetAllSupplier(() -> handles).build();
        Assert.assertThrows(FlinkException.class, () -> DefaultCompletedCheckpointStoreUtils.retrieveCompletedCheckpoints((StateHandleStore)stateHandleStore, (CheckpointStoreUtil)new SimpleCheckpointStoreUtil()));
    }

    private static class SimpleCheckpointStoreUtil
    implements CheckpointStoreUtil {
        private SimpleCheckpointStoreUtil() {
        }

        public String checkpointIDToName(long checkpointId) {
            return "checkpoint-" + checkpointId;
        }

        public long nameToCheckpointID(String name) {
            return Long.parseLong(name.split("-")[1]);
        }
    }

    private static class FailingRetrievableStateHandle<T extends Serializable>
    implements RetrievableStateHandle<T> {
        private static final int serialVersionUID = 1;

        private FailingRetrievableStateHandle() {
        }

        public T retrieveState() throws IOException, ClassNotFoundException {
            throw new IOException("Test exception.");
        }

        public void discardState() throws Exception {
        }

        public long getStateSize() {
            return 0L;
        }
    }
}

