/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummarySnapshot;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointStatsTrackerTest {
    @Test
    public void testGetSnapshottingSettings() throws Exception {
        JobCheckpointingSettings snapshottingSettings = new JobCheckpointingSettings(new CheckpointCoordinatorConfiguration(181238123L, 19191992L, 191929L, 123, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, false, false, 0, 0L), null);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(0, snapshottingSettings.getCheckpointCoordinatorConfiguration(), (MetricGroup)new UnregisteredMetricsGroup());
        Assert.assertEquals((Object)snapshottingSettings.getCheckpointCoordinatorConfiguration(), (Object)tracker.getJobCheckpointingConfiguration());
    }

    @Test
    public void testTrackerWithoutHistory() throws Exception {
        JobVertexID jobVertexID = new JobVertexID();
        ExecutionGraph graph = new CheckpointCoordinatorTestingUtils.CheckpointExecutionGraphBuilder().addJobVertex(jobVertexID, 3, 256).build();
        ExecutionJobVertex jobVertex = graph.getJobVertex(jobVertexID);
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(0, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)new UnregisteredMetricsGroup());
        PendingCheckpointStats pending = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), Collections.singletonMap(jobVertexID, jobVertex.getParallelism()));
        pending.reportSubtaskStats(jobVertexID, this.createSubtaskStats(0));
        pending.reportSubtaskStats(jobVertexID, this.createSubtaskStats(1));
        pending.reportSubtaskStats(jobVertexID, this.createSubtaskStats(2));
        pending.reportCompletedCheckpoint(null);
        CheckpointStatsSnapshot snapshot = tracker.createSnapshot();
        Assert.assertFalse((boolean)snapshot.getHistory().getCheckpoints().iterator().hasNext());
        CheckpointStatsCounts counts = snapshot.getCounts();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getTotalNumberOfCheckpoints());
        CompletedCheckpointStatsSummarySnapshot summary = snapshot.getSummaryStats();
        Assert.assertEquals((long)1L, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)1L, (long)summary.getEndToEndDurationStats().getCount());
        Assert.assertNotNull((Object)snapshot.getHistory().getLatestCompletedCheckpoint());
        Assert.assertEquals((long)0L, (long)snapshot.getHistory().getLatestCompletedCheckpoint().getCheckpointId());
    }

    @Test
    public void testCheckpointTracking() throws Exception {
        JobVertexID jobVertexID = new JobVertexID();
        ExecutionGraph graph = new CheckpointCoordinatorTestingUtils.CheckpointExecutionGraphBuilder().addJobVertex(jobVertexID, 3, 256).build();
        ExecutionJobVertex jobVertex = graph.getJobVertex(jobVertexID);
        Map<JobVertexID, Integer> vertexToDop = Collections.singletonMap(jobVertexID, jobVertex.getParallelism());
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(10, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)new UnregisteredMetricsGroup());
        PendingCheckpointStats completed1 = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), vertexToDop);
        completed1.reportSubtaskStats(jobVertexID, this.createSubtaskStats(0));
        completed1.reportSubtaskStats(jobVertexID, this.createSubtaskStats(1));
        completed1.reportSubtaskStats(jobVertexID, this.createSubtaskStats(2));
        completed1.reportCompletedCheckpoint(null);
        PendingCheckpointStats failed = tracker.reportPendingCheckpoint(1L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), vertexToDop);
        failed.reportFailedCheckpoint(12L, null);
        PendingCheckpointStats savepoint = tracker.reportPendingCheckpoint(2L, 1L, CheckpointProperties.forSavepoint((boolean)true), vertexToDop);
        savepoint.reportSubtaskStats(jobVertexID, this.createSubtaskStats(0));
        savepoint.reportSubtaskStats(jobVertexID, this.createSubtaskStats(1));
        savepoint.reportSubtaskStats(jobVertexID, this.createSubtaskStats(2));
        savepoint.reportCompletedCheckpoint(null);
        PendingCheckpointStats inProgress = tracker.reportPendingCheckpoint(3L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), vertexToDop);
        RestoredCheckpointStats restored = new RestoredCheckpointStats(81L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 123L, null);
        tracker.reportRestoredCheckpoint(restored);
        CheckpointStatsSnapshot snapshot = tracker.createSnapshot();
        CheckpointStatsCounts counts = snapshot.getCounts();
        Assert.assertEquals((long)4L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)2L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfFailedCheckpoints());
        CompletedCheckpointStatsSummarySnapshot summary = snapshot.getSummaryStats();
        Assert.assertEquals((long)2L, (long)summary.getStateSizeStats().getCount());
        Assert.assertEquals((long)2L, (long)summary.getEndToEndDurationStats().getCount());
        CheckpointStatsHistory history = snapshot.getHistory();
        Iterator it = history.getCheckpoints().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)3L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isInProgress());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)2L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)1L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isFailed());
        Assert.assertTrue((boolean)it.hasNext());
        stats = (AbstractCheckpointStats)it.next();
        Assert.assertEquals((long)0L, (long)stats.getCheckpointId());
        Assert.assertTrue((boolean)stats.getStatus().isCompleted());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)completed1.getCheckpointId(), (long)snapshot.getHistory().getLatestCompletedCheckpoint().getCheckpointId());
        Assert.assertEquals((long)savepoint.getCheckpointId(), (long)snapshot.getHistory().getLatestSavepoint().getCheckpointId());
        Assert.assertEquals((long)failed.getCheckpointId(), (long)snapshot.getHistory().getLatestFailedCheckpoint().getCheckpointId());
        Assert.assertEquals((Object)restored, (Object)snapshot.getLatestRestoredCheckpoint());
    }

    @Test
    public void testCreateSnapshot() throws Exception {
        JobVertexID jobVertexID = new JobVertexID();
        CheckpointStatsTracker tracker = new CheckpointStatsTracker(10, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)new UnregisteredMetricsGroup());
        CheckpointStatsSnapshot snapshot1 = tracker.createSnapshot();
        PendingCheckpointStats pending = tracker.reportPendingCheckpoint(0L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), Collections.singletonMap(jobVertexID, 1));
        pending.reportSubtaskStats(jobVertexID, this.createSubtaskStats(0));
        CheckpointStatsSnapshot snapshot2 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot1, (Object)snapshot2);
        Assert.assertEquals((Object)snapshot2, (Object)tracker.createSnapshot());
        pending.reportCompletedCheckpoint(null);
        CheckpointStatsSnapshot snapshot3 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot2, (Object)snapshot3);
        tracker.reportRestoredCheckpoint(new RestoredCheckpointStats(12L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 12L, null));
        CheckpointStatsSnapshot snapshot4 = tracker.createSnapshot();
        Assert.assertNotEquals((Object)snapshot3, (Object)snapshot4);
        Assert.assertEquals((Object)snapshot4, (Object)tracker.createSnapshot());
    }

    @Test
    public void testMetricsRegistration() throws Exception {
        final ArrayList registeredGaugeNames = new ArrayList();
        UnregisteredMetricsGroup metricGroup = new UnregisteredMetricsGroup(){

            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                if (gauge != null) {
                    registeredGaugeNames.add(name);
                }
                return gauge;
            }
        };
        new CheckpointStatsTracker(0, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)metricGroup);
        Assert.assertTrue((boolean)registeredGaugeNames.containsAll(Arrays.asList("totalNumberOfCheckpoints", "numberOfInProgressCheckpoints", "numberOfCompletedCheckpoints", "numberOfFailedCheckpoints", "lastCheckpointRestoreTimestamp", "lastCheckpointSize", "lastCheckpointDuration", "lastCheckpointProcessedData", "lastCheckpointPersistedData", "lastCheckpointExternalPath")));
        Assert.assertEquals((long)10L, (long)registeredGaugeNames.size());
    }

    @Test
    public void testMetricsAreUpdated() throws Exception {
        final HashMap registeredGauges = new HashMap();
        UnregisteredMetricsGroup metricGroup = new UnregisteredMetricsGroup(){

            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                registeredGauges.put(name, gauge);
                return gauge;
            }
        };
        JobVertexID jobVertexID = new JobVertexID();
        ExecutionGraph graph = new CheckpointCoordinatorTestingUtils.CheckpointExecutionGraphBuilder().addJobVertex(jobVertexID).build();
        ExecutionJobVertex jobVertex = graph.getJobVertex(jobVertexID);
        CheckpointStatsTracker stats = new CheckpointStatsTracker(0, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)metricGroup);
        Assert.assertEquals((long)10L, (long)registeredGauges.size());
        Gauge numCheckpoints = (Gauge)registeredGauges.get("totalNumberOfCheckpoints");
        Gauge numInProgressCheckpoints = (Gauge)registeredGauges.get("numberOfInProgressCheckpoints");
        Gauge numCompletedCheckpoints = (Gauge)registeredGauges.get("numberOfCompletedCheckpoints");
        Gauge numFailedCheckpoints = (Gauge)registeredGauges.get("numberOfFailedCheckpoints");
        Gauge latestRestoreTimestamp = (Gauge)registeredGauges.get("lastCheckpointRestoreTimestamp");
        Gauge latestCompletedSize = (Gauge)registeredGauges.get("lastCheckpointSize");
        Gauge latestCompletedDuration = (Gauge)registeredGauges.get("lastCheckpointDuration");
        Gauge latestProcessedData = (Gauge)registeredGauges.get("lastCheckpointProcessedData");
        Gauge latestPersistedData = (Gauge)registeredGauges.get("lastCheckpointPersistedData");
        Gauge latestCompletedExternalPath = (Gauge)registeredGauges.get("lastCheckpointExternalPath");
        Assert.assertEquals((Object)0L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestRestoreTimestamp.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestCompletedSize.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestCompletedDuration.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestProcessedData.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestPersistedData.getValue());
        Assert.assertEquals((Object)"n/a", (Object)latestCompletedExternalPath.getValue());
        PendingCheckpointStats pending = stats.reportPendingCheckpoint(0L, 0L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), Collections.singletonMap(jobVertexID, 1));
        Assert.assertEquals((Object)1L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)1, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        long ackTimestamp = 11231230L;
        long stateSize = 12381238L;
        long processedData = 4242L;
        long persistedData = 4444L;
        long ignored = 0L;
        String externalPath = "myexternalpath";
        SubtaskStateStats subtaskStats = new SubtaskStateStats(0, ackTimestamp, stateSize, ignored, ignored, processedData, persistedData, ignored, ignored, false, true);
        Assert.assertTrue((boolean)pending.reportSubtaskStats(jobVertexID, subtaskStats));
        pending.reportCompletedCheckpoint(externalPath);
        Assert.assertEquals((Object)1L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)0L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)-1L, (Object)latestRestoreTimestamp.getValue());
        Assert.assertEquals((Object)stateSize, (Object)latestCompletedSize.getValue());
        Assert.assertEquals((Object)processedData, (Object)latestProcessedData.getValue());
        Assert.assertEquals((Object)persistedData, (Object)latestPersistedData.getValue());
        Assert.assertEquals((Object)ackTimestamp, (Object)latestCompletedDuration.getValue());
        Assert.assertEquals((Object)externalPath, (Object)latestCompletedExternalPath.getValue());
        PendingCheckpointStats nextPending = stats.reportPendingCheckpoint(1L, 11L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), Collections.singletonMap(jobVertexID, 1));
        long failureTimestamp = 1230123L;
        nextPending.reportFailedCheckpoint(failureTimestamp, null);
        Assert.assertEquals((Object)2L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numFailedCheckpoints.getValue());
        long restoreTimestamp = 183419283L;
        RestoredCheckpointStats restored = new RestoredCheckpointStats(1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), restoreTimestamp, null);
        stats.reportRestoredCheckpoint(restored);
        Assert.assertEquals((Object)2L, (Object)numCheckpoints.getValue());
        Assert.assertEquals((Object)0, (Object)numInProgressCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numCompletedCheckpoints.getValue());
        Assert.assertEquals((Object)1L, (Object)numFailedCheckpoints.getValue());
        Assert.assertEquals((Object)restoreTimestamp, (Object)latestRestoreTimestamp.getValue());
        PendingCheckpointStats thirdPending = stats.reportPendingCheckpoint(2L, 5000L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), Collections.singletonMap(jobVertexID, 1));
        thirdPending.reportSubtaskStats(jobVertexID, subtaskStats);
        thirdPending.reportCompletedCheckpoint(null);
        Assert.assertEquals((Object)"n/a", (Object)latestCompletedExternalPath.getValue());
    }

    private SubtaskStateStats createSubtaskStats(int index) {
        return new SubtaskStateStats(index, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, true);
    }
}

