/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.failover.flip1.PipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.topology.LogicalResult;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;

public final class LogicalPipelinedRegionComputeUtil {
    public static Set<Set<LogicalVertex>> computePipelinedRegions(Iterable<? extends LogicalVertex> topologicallySortedVertices) {
        Map<LogicalVertex, Set<LogicalVertex>> vertexToRegion = PipelinedRegionComputeUtil.buildRawRegions(topologicallySortedVertices, LogicalPipelinedRegionComputeUtil::getNonReconnectableConsumedResults);
        return PipelinedRegionComputeUtil.uniqueRegions(vertexToRegion);
    }

    private static Iterable<LogicalResult> getNonReconnectableConsumedResults(LogicalVertex vertex) {
        ArrayList<LogicalResult> nonReconnectableConsumedResults = new ArrayList<LogicalResult>();
        for (LogicalResult consumedResult : vertex.getConsumedResults()) {
            if (consumedResult.getResultType().isReconnectable()) continue;
            nonReconnectableConsumedResults.add(consumedResult);
        }
        return nonReconnectableConsumedResults;
    }

    private LogicalPipelinedRegionComputeUtil() {
    }
}

