/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(AccumulatorRegistry.class);
    protected final JobID jobID;
    protected final ExecutionAttemptID taskID;
    private final Map<String, Accumulator<?, ?>> userAccumulators = new ConcurrentHashMap(4);

    public AccumulatorRegistry(JobID jobID, ExecutionAttemptID taskID) {
        this.jobID = jobID;
        this.taskID = taskID;
    }

    public AccumulatorSnapshot getSnapshot() {
        try {
            return new AccumulatorSnapshot(this.jobID, this.taskID, this.userAccumulators);
        }
        catch (Throwable e) {
            LOG.warn("Failed to serialize accumulators for task.", e);
            return null;
        }
    }

    public Map<String, Accumulator<?, ?>> getUserMap() {
        return this.userAccumulators;
    }
}

