/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.curator.test.TestingCluster;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ExitJVMFatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.KeeperException;

public class ZooKeeperTestEnvironment {
    private final TestingServer zooKeeperServer;
    private final TestingCluster zooKeeperCluster;
    private final CuratorFramework client;
    private final CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;

    public ZooKeeperTestEnvironment(int numberOfZooKeeperQuorumPeers) {
        if (numberOfZooKeeperQuorumPeers <= 0) {
            throw new IllegalArgumentException("Number of peers needs to be >= 1.");
        }
        Configuration conf = new Configuration();
        try {
            if (numberOfZooKeeperQuorumPeers == 1) {
                this.zooKeeperServer = new TestingServer(true);
                this.zooKeeperCluster = null;
                conf.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.zooKeeperServer.getConnectString());
            } else {
                this.zooKeeperServer = null;
                this.zooKeeperCluster = new TestingCluster(numberOfZooKeeperQuorumPeers);
                this.zooKeeperCluster.start();
                conf.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.zooKeeperCluster.getConnectString());
            }
            this.curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)conf, (FatalErrorHandler)ExitJVMFatalErrorHandler.INSTANCE);
            this.client = this.curatorFrameworkWrapper.asCuratorFramework();
            this.client.newNamespaceAwareEnsurePath("/").ensure(this.client.getZookeeperClient());
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up ZooKeeperTestEnvironment", e);
        }
    }

    public void shutdown() throws Exception {
        if (this.curatorFrameworkWrapper != null) {
            this.curatorFrameworkWrapper.close();
        }
        if (this.zooKeeperServer != null) {
            this.zooKeeperServer.close();
        }
        if (this.zooKeeperCluster != null) {
            this.zooKeeperCluster.close();
        }
    }

    public String getConnectString() {
        if (this.zooKeeperServer != null) {
            return this.zooKeeperServer.getConnectString();
        }
        return this.zooKeeperCluster.getConnectString();
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public String getClientNamespace() {
        return this.client.getNamespace();
    }

    @Nullable
    public TestingCluster getZooKeeperCluster() {
        return this.zooKeeperCluster;
    }

    public List<String> getChildren(String path) throws Exception {
        return (List)this.client.getChildren().forPath(path);
    }

    public void deleteAll() throws Exception {
        String path = "/" + this.client.getNamespace();
        int maxAttempts = 10;
        for (int i = 0; i < maxAttempts; ++i) {
            try {
                ZKPaths.deleteChildren((ZooKeeper)this.client.getZookeeperClient().getZooKeeper(), (String)path, (boolean)false);
                return;
            }
            catch (KeeperException.NoNodeException e) {
                return;
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.sleep(100L);
                continue;
            }
        }
        throw new Exception("Could not clear the ZNodes under " + path + ". ZooKeeper is not in a clean state.");
    }
}

