/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.util.AtomicDisposableReferenceCounter;
import org.junit.Assert;
import org.junit.Test;

public class AtomicDisposableReferenceCounterTest {
    @Test
    public void testSerialIncrementAndDecrement() {
        AtomicDisposableReferenceCounter counter = new AtomicDisposableReferenceCounter();
        Assert.assertTrue((boolean)counter.increment());
        Assert.assertTrue((boolean)counter.decrement());
        Assert.assertFalse((boolean)counter.increment());
        Assert.assertFalse((boolean)counter.decrement());
    }

    @Test
    public void testSerialIncrementAndDecrementWithCustomDisposeCount() {
        AtomicDisposableReferenceCounter counter = new AtomicDisposableReferenceCounter(-2);
        Assert.assertTrue((boolean)counter.increment());
        Assert.assertFalse((boolean)counter.decrement());
        Assert.assertFalse((boolean)counter.decrement());
        Assert.assertTrue((boolean)counter.decrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentIncrementAndDecrement() throws InterruptedException, ExecutionException, TimeoutException {
        Random random = new Random();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            MockIncrementer incrementer = new MockIncrementer();
            MockDecrementer decrementer = new MockDecrementer();
            for (int i = 0; i < 256; ++i) {
                AtomicDisposableReferenceCounter counter = new AtomicDisposableReferenceCounter();
                incrementer.setCounter(counter);
                decrementer.setCounter(counter);
                counter.increment();
                boolean incrementFirst = random.nextBoolean();
                Future<Boolean> success1 = executor.submit(incrementFirst ? incrementer : decrementer);
                Future<Boolean> success2 = executor.submit(incrementFirst ? decrementer : incrementer);
                Assert.assertTrue((boolean)(success1.get() ^ success2.get()));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static class MockDecrementer
    implements Callable<Boolean> {
        private AtomicDisposableReferenceCounter counter;

        private MockDecrementer() {
        }

        void setCounter(AtomicDisposableReferenceCounter counter) {
            this.counter = counter;
        }

        @Override
        public Boolean call() throws Exception {
            return this.counter.decrement();
        }
    }

    private static class MockIncrementer
    implements Callable<Boolean> {
        private AtomicDisposableReferenceCounter counter;

        private MockIncrementer() {
        }

        void setCounter(AtomicDisposableReferenceCounter counter) {
            this.counter = counter;
        }

        @Override
        public Boolean call() throws Exception {
            return this.counter.increment();
        }
    }
}

