/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import org.apache.flink.runtime.throughput.ThroughputEMA;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ThroughputEMATest
extends TestLogger {
    @Test
    public void testWarmUpThroughputCalculation() {
        ThroughputEMA calculator = new ThroughputEMA(5L);
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 33L), (Matcher)Matchers.is((Object)3030L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(200L, 33L), (Matcher)Matchers.is((Object)4040L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 9L), (Matcher)Matchers.is((Object)6397L));
    }

    @Test
    public void testWarmUpIsFinished() {
        ThroughputEMA calculator = new ThroughputEMA(2L);
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 33L), (Matcher)Matchers.is((Object)3030L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(200L, 33L), (Matcher)Matchers.is((Object)5050L));
    }

    @Test
    public void testCalculationThroughput() {
        ThroughputEMA calculator = new ThroughputEMA(3L);
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 33L), (Matcher)Matchers.is((Object)3030L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(200L, 33L), (Matcher)Matchers.is((Object)4545L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)7272L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)8636L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)9318L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)9659L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)9829L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)9914L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 10L), (Matcher)Matchers.is((Object)9957L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(10L, 10L), (Matcher)Matchers.is((Object)5478L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(10L, 10L), (Matcher)Matchers.is((Object)3239L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(10L, 10L), (Matcher)Matchers.is((Object)2119L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeDataSize() {
        ThroughputEMA calculator = new ThroughputEMA(2L);
        calculator.calculateThroughput(-1L, 1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeTime() {
        ThroughputEMA calculator = new ThroughputEMA(2L);
        calculator.calculateThroughput(1L, -1L);
    }

    @Test
    public void testPreviousValueWhenTimeIsZero() {
        ThroughputEMA calculator = new ThroughputEMA(2L);
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(100L, 33L), (Matcher)Matchers.is((Object)3030L));
        MatcherAssert.assertThat((Object)calculator.calculateThroughput(200L, 0L), (Matcher)Matchers.is((Object)3030L));
    }
}

