/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.LatencyTrackingListState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateTestBase;
import org.junit.Assert;
import org.junit.Test;

public class LatencyTrackingListStateTest
extends LatencyTrackingStateTestBase<Integer> {
    ListStateDescriptor<Long> getStateDescriptor() {
        return new ListStateDescriptor("list", Long.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatencyTrackingListState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingListState latencyTrackingState = (LatencyTrackingListState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingListState.ListStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingListState.ListStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getAddCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getAddAllCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getGetCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getUpdateCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getMergeNamespaceCount());
            this.setCurrentKey(keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.add((Object)ThreadLocalRandom.current().nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getAddCount());
                latencyTrackingState.addAll(Collections.singletonList(ThreadLocalRandom.current().nextLong()));
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getAddAllCount());
                latencyTrackingState.update(Collections.singletonList(ThreadLocalRandom.current().nextLong()));
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getUpdateCount());
                latencyTrackingState.get();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getGetCount());
                latencyTrackingState.mergeNamespaces((Object)VoidNamespace.INSTANCE, Collections.emptyList());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getMergeNamespaceCount());
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

