/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.StateBackendMigrationTestBase;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashMapStateBackendMigrationTest
extends StateBackendMigrationTestBase<HashMapStateBackend> {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    @Parameterized.Parameter
    public SupplierWithException<CheckpointStorage, IOException> storageSupplier;

    @Parameterized.Parameters
    public static Object[] modes() {
        return new Object[]{JobManagerCheckpointStorage::new, () -> {
            String checkpointPath = TEMP_FOLDER.newFolder().toURI().toString();
            return new FileSystemCheckpointStorage(checkpointPath);
        }};
    }

    @Override
    protected HashMapStateBackend getStateBackend() throws Exception {
        return new HashMapStateBackend();
    }

    @Override
    protected CheckpointStorage getCheckpointStorage() throws Exception {
        return (CheckpointStorage)this.storageSupplier.get();
    }
}

