/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.runtime.topology.VertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipelinedRegionSchedulingStrategyTest
extends TestLogger {
    private TestingSchedulerOperations testingSchedulerOperation;
    private static final int PARALLELISM = 2;
    private TestingSchedulingTopology testingSchedulingTopology;
    private List<TestingSchedulingExecutionVertex> source;
    private List<TestingSchedulingExecutionVertex> map;
    private List<TestingSchedulingExecutionVertex> sink;

    @Before
    public void setUp() {
        this.testingSchedulerOperation = new TestingSchedulerOperations();
        this.buildTopology();
    }

    private void buildTopology() {
        this.testingSchedulingTopology = new TestingSchedulingTopology();
        this.source = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.map = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.sink = this.testingSchedulingTopology.addExecutionVertices().withParallelism(2).finish();
        this.testingSchedulingTopology.connectPointwise(this.source, this.map).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.PIPELINED_BOUNDED).finish();
        this.testingSchedulingTopology.connectAllToAll(this.map, this.sink).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
    }

    @Test
    public void testStartScheduling() {
        this.startScheduling(this.testingSchedulingTopology);
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.source.get(0), this.map.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.source.get(1), this.map.get(1)));
        this.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices);
    }

    @Test
    public void testRestartTasks() {
        PipelinedRegionSchedulingStrategy schedulingStrategy = this.startScheduling(this.testingSchedulingTopology);
        Set verticesToRestart = Stream.of(this.source, this.map, this.sink).flatMap(Collection::stream).map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toSet());
        schedulingStrategy.restartTasks(verticesToRestart);
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.source.get(0), this.map.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.source.get(1), this.map.get(1)));
        this.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices);
    }

    @Test
    public void testNotifyingBlockingResultPartitionProducerFinished() {
        PipelinedRegionSchedulingStrategy schedulingStrategy = this.startScheduling(this.testingSchedulingTopology);
        TestingSchedulingExecutionVertex map1 = this.map.get(0);
        map1.getProducedResults().iterator().next().markFinished();
        schedulingStrategy.onExecutionStateChange(map1.getId(), ExecutionState.FINISHED);
        Assert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)2));
        TestingSchedulingExecutionVertex map2 = this.map.get(1);
        map2.getProducedResults().iterator().next().markFinished();
        schedulingStrategy.onExecutionStateChange(map2.getId(), ExecutionState.FINISHED);
        Assert.assertThat(this.testingSchedulerOperation.getScheduledVertices(), (Matcher)Matchers.hasSize((int)4));
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(this.sink.get(0)));
        expectedScheduledVertices.add(Arrays.asList(this.sink.get(1)));
        this.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices);
    }

    @Test
    public void testSchedulingTopologyWithPersistentBlockingEdges() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> v1 = topology.addExecutionVertices().withParallelism(1).finish();
        List<TestingSchedulingExecutionVertex> v2 = topology.addExecutionVertices().withParallelism(1).finish();
        topology.connectPointwise(v1, v2).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING_PERSISTENT).finish();
        this.startScheduling(topology);
        ArrayList<List<TestingSchedulingExecutionVertex>> expectedScheduledVertices = new ArrayList<List<TestingSchedulingExecutionVertex>>();
        expectedScheduledVertices.add(Arrays.asList(v1.get(0)));
        this.assertLatestScheduledVerticesAreEqualTo(expectedScheduledVertices);
    }

    @Test
    public void testComputingCrossRegionConsumedPartitionGroupsCorrectly() throws Exception {
        JobVertex v1 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v1", 4);
        JobVertex v2 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v2", 3);
        JobVertex v3 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v3", 2);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        v3.connectNewDataSetAsInput(v2, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        v3.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3));
        JobGraph jobGraph = JobGraphBuilder.newBatchJobGraphBuilder().addJobVertices(ordered).build();
        DefaultExecutionGraph executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build();
        SchedulingTopology schedulingTopology = executionGraph.getSchedulingTopology();
        PipelinedRegionSchedulingStrategy schedulingStrategy = new PipelinedRegionSchedulingStrategy((SchedulerOperations)this.testingSchedulerOperation, schedulingTopology);
        Set crossRegionConsumedPartitionGroups = schedulingStrategy.getCrossRegionConsumedPartitionGroups();
        Assert.assertEquals((long)1L, (long)crossRegionConsumedPartitionGroups.size());
        ConsumedPartitionGroup expected = (ConsumedPartitionGroup)executionGraph.getJobVertex(v3.getID()).getTaskVertices()[1].getAllConsumedPartitionGroups().get(0);
        Assert.assertTrue((boolean)crossRegionConsumedPartitionGroups.contains(expected));
    }

    @Test
    public void testNoCrossRegionConsumedPartitionGroupsWithAllToAllBlockingEdge() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producer = topology.addExecutionVertices().withParallelism(4).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(4).finish();
        topology.connectAllToAll(producer, consumer).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        PipelinedRegionSchedulingStrategy schedulingStrategy = new PipelinedRegionSchedulingStrategy((SchedulerOperations)this.testingSchedulerOperation, (SchedulingTopology)topology);
        Set crossRegionConsumedPartitionGroups = schedulingStrategy.getCrossRegionConsumedPartitionGroups();
        Assert.assertEquals((long)0L, (long)crossRegionConsumedPartitionGroups.size());
    }

    @Test
    public void testSchedulingTopologyWithCrossRegionConsumedPartitionGroups() throws Exception {
        JobVertex v1 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v1", 4);
        JobVertex v2 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v2", 3);
        JobVertex v3 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v3", 2);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        v3.connectNewDataSetAsInput(v2, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        v3.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3));
        JobGraph jobGraph = JobGraphBuilder.newBatchJobGraphBuilder().addJobVertices(ordered).build();
        DefaultExecutionGraph executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build();
        SchedulingTopology schedulingTopology = executionGraph.getSchedulingTopology();
        ArrayList regions = new ArrayList();
        schedulingTopology.getAllPipelinedRegions().forEach(regions::add);
        Assert.assertEquals((long)2L, (long)regions.size());
        ExecutionVertex v31 = executionGraph.getJobVertex(v3.getID()).getTaskVertices()[0];
        HashSet region1 = new HashSet();
        ((SchedulingPipelinedRegion)schedulingTopology.getPipelinedRegionOfVertex((VertexID)v31.getID())).getVertices().forEach(vertex -> region1.add(vertex.getId()));
        Assert.assertEquals((long)5L, (long)region1.size());
        ExecutionVertex v32 = executionGraph.getJobVertex(v3.getID()).getTaskVertices()[1];
        HashSet region2 = new HashSet();
        ((SchedulingPipelinedRegion)schedulingTopology.getPipelinedRegionOfVertex((VertexID)v32.getID())).getVertices().forEach(vertex -> region2.add(vertex.getId()));
        Assert.assertEquals((long)4L, (long)region2.size());
        PipelinedRegionSchedulingStrategy schedulingStrategy = this.startScheduling(schedulingTopology);
        Assert.assertEquals((long)1L, (long)this.testingSchedulerOperation.getScheduledVertices().size());
        List<ExecutionVertexDeploymentOption> deploymentOptions1 = this.testingSchedulerOperation.getScheduledVertices().get(0);
        Assert.assertEquals((long)5L, (long)deploymentOptions1.size());
        for (ExecutionVertexDeploymentOption deploymentOption : deploymentOptions1) {
            Assert.assertTrue((boolean)region1.contains(deploymentOption.getExecutionVertexId()));
        }
        ExecutionVertex v22 = executionGraph.getJobVertex(v2.getID()).getTaskVertices()[1];
        v22.finishAllBlockingPartitions();
        schedulingStrategy.onExecutionStateChange(v22.getID(), ExecutionState.FINISHED);
        Assert.assertEquals((long)2L, (long)this.testingSchedulerOperation.getScheduledVertices().size());
        List<ExecutionVertexDeploymentOption> deploymentOptions2 = this.testingSchedulerOperation.getScheduledVertices().get(1);
        Assert.assertEquals((long)4L, (long)deploymentOptions2.size());
        for (ExecutionVertexDeploymentOption deploymentOption : deploymentOptions2) {
            Assert.assertTrue((boolean)region2.contains(deploymentOption.getExecutionVertexId()));
        }
    }

    @Test
    public void testScheduleBlockingDownstreamTaskIndividually() throws Exception {
        JobVertex v1 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v1", 2);
        JobVertex v2 = PipelinedRegionSchedulingStrategyTest.createJobVertex("v2", 2);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        JobGraph jobGraph = JobGraphBuilder.newBatchJobGraphBuilder().addJobVertices(ordered).build();
        DefaultExecutionGraph executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build();
        SchedulingTopology schedulingTopology = executionGraph.getSchedulingTopology();
        PipelinedRegionSchedulingStrategy schedulingStrategy = this.startScheduling(schedulingTopology);
        Assert.assertEquals((long)2L, (long)this.testingSchedulerOperation.getScheduledVertices().size());
        ExecutionVertex v11 = executionGraph.getJobVertex(v1.getID()).getTaskVertices()[0];
        v11.finishAllBlockingPartitions();
        schedulingStrategy.onExecutionStateChange(v11.getID(), ExecutionState.FINISHED);
        Assert.assertEquals((long)3L, (long)this.testingSchedulerOperation.getScheduledVertices().size());
    }

    private static JobVertex createJobVertex(String vertexName, int parallelism) {
        JobVertex jobVertex = new JobVertex(vertexName);
        jobVertex.setParallelism(parallelism);
        jobVertex.setInvokableClass(AbstractInvokable.class);
        return jobVertex;
    }

    private PipelinedRegionSchedulingStrategy startScheduling(SchedulingTopology schedulingTopology) {
        PipelinedRegionSchedulingStrategy schedulingStrategy = new PipelinedRegionSchedulingStrategy((SchedulerOperations)this.testingSchedulerOperation, schedulingTopology);
        schedulingStrategy.startScheduling();
        return schedulingStrategy;
    }

    private void assertLatestScheduledVerticesAreEqualTo(List<List<TestingSchedulingExecutionVertex>> expected) {
        List<List<ExecutionVertexDeploymentOption>> deploymentOptions = this.testingSchedulerOperation.getScheduledVertices();
        int expectedScheduledBulks = expected.size();
        Assert.assertThat((Object)expectedScheduledBulks, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(deploymentOptions.size())));
        for (int i = 0; i < expectedScheduledBulks; ++i) {
            Assert.assertEquals(PipelinedRegionSchedulingStrategyTest.idsFromVertices(expected.get(expectedScheduledBulks - i - 1)), PipelinedRegionSchedulingStrategyTest.idsFromDeploymentOptions(deploymentOptions.get(deploymentOptions.size() - i - 1)));
        }
    }

    private static List<ExecutionVertexID> idsFromVertices(List<TestingSchedulingExecutionVertex> vertices) {
        return vertices.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList());
    }

    private static List<ExecutionVertexID> idsFromDeploymentOptions(List<ExecutionVertexDeploymentOption> deploymentOptions) {
        return deploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).collect(Collectors.toList());
    }
}

