/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.savepoints;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.handler.job.savepoints.SavepointHandlers;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointInfo;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.stop.StopWithSavepointRequestBody;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StopWithSavepointHandlersTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static final JobID JOB_ID = new JobID();
    private static final String COMPLETED_SAVEPOINT_EXTERNAL_POINTER = "/tmp/stop-savepoint-0d2fb9-8d5e0106041a";
    private static final String DEFAULT_REQUESTED_SAVEPOINT_TARGET_DIRECTORY = "/tmp";
    private SavepointHandlers.StopWithSavepointHandler savepointTriggerHandler;
    private SavepointHandlers.SavepointStatusHandler savepointStatusHandler;
    private GatewayRetriever<RestfulGateway> leaderRetriever;

    @Before
    public void setUp() throws Exception {
        SavepointHandlers savepointHandlers;
        this.leaderRetriever = () -> CompletableFuture.completedFuture(null);
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers(null);
        savepointHandlers2.getClass();
        this.savepointTriggerHandler = new SavepointHandlers.StopWithSavepointHandler(savepointHandlers2, this.leaderRetriever, TIMEOUT, Collections.emptyMap());
        SavepointHandlers savepointHandlers3 = savepointHandlers;
        savepointHandlers3.getClass();
        this.savepointStatusHandler = new SavepointHandlers.SavepointStatusHandler(savepointHandlers3, this.leaderRetriever, TIMEOUT, Collections.emptyMap());
    }

    @Test
    public void testSavepointCompletedSuccessfully() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setStopWithSavepointFunction((jobId, targetDirectory) -> CompletableFuture.completedFuture(COMPLETED_SAVEPOINT_EXTERNAL_POINTER))).build();
        TriggerId triggerId = ((TriggerResponse)this.savepointTriggerHandler.handleRequest(StopWithSavepointHandlersTest.triggerSavepointRequest(), (RestfulGateway)testingRestfulGateway).get()).getTriggerId();
        AsynchronousOperationResult savepointResponseBody = (AsynchronousOperationResult)this.savepointStatusHandler.handleRequest(StopWithSavepointHandlersTest.savepointStatusRequest(triggerId), (RestfulGateway)testingRestfulGateway).get();
        Assert.assertThat((Object)savepointResponseBody.queueStatus().getId(), (Matcher)Matchers.equalTo((Object)QueueStatus.Id.COMPLETED));
        Assert.assertThat((Object)savepointResponseBody.resource(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((SavepointInfo)savepointResponseBody.resource()).getLocation(), (Matcher)Matchers.equalTo((Object)COMPLETED_SAVEPOINT_EXTERNAL_POINTER));
    }

    @Test
    public void testTriggerSavepointWithDefaultDirectory() throws Exception {
        SavepointHandlers savepointHandlers;
        CompletableFuture targetDirectoryFuture = new CompletableFuture();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setStopWithSavepointFunction((jobId, targetDirectory) -> {
            targetDirectoryFuture.complete(targetDirectory);
            return CompletableFuture.completedFuture(COMPLETED_SAVEPOINT_EXTERNAL_POINTER);
        })).build();
        String defaultSavepointDir = "/other/dir";
        SavepointHandlers savepointHandlers2 = savepointHandlers = new SavepointHandlers("/other/dir");
        savepointHandlers2.getClass();
        SavepointHandlers.StopWithSavepointHandler savepointTriggerHandler = new SavepointHandlers.StopWithSavepointHandler(savepointHandlers2, this.leaderRetriever, TIMEOUT, Collections.emptyMap());
        savepointTriggerHandler.handleRequest(StopWithSavepointHandlersTest.triggerSavepointRequestWithDefaultDirectory(), (RestfulGateway)testingRestfulGateway).get();
        Assert.assertThat(targetDirectoryFuture.get(), (Matcher)Matchers.equalTo((Object)"/other/dir"));
    }

    @Test
    public void testTriggerSavepointNoDirectory() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setStopWithSavepointFunction((jobId, directory) -> CompletableFuture.completedFuture(COMPLETED_SAVEPOINT_EXTERNAL_POINTER))).build();
        try {
            this.savepointTriggerHandler.handleRequest(StopWithSavepointHandlersTest.triggerSavepointRequestWithDefaultDirectory(), (RestfulGateway)testingRestfulGateway).get();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (RestHandlerException rhe) {
            Assert.assertThat((Object)rhe.getMessage(), (Matcher)Matchers.equalTo((Object)"Config key [state.savepoints.dir] is not set. Property [targetDirectory] must be provided."));
            Assert.assertThat((Object)rhe.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.BAD_REQUEST));
        }
    }

    @Test
    public void testSavepointCompletedWithException() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setStopWithSavepointFunction((jobId, directory) -> FutureUtils.completedExceptionally((Throwable)new RuntimeException("expected")))).build();
        TriggerId triggerId = ((TriggerResponse)this.savepointTriggerHandler.handleRequest(StopWithSavepointHandlersTest.triggerSavepointRequest(), (RestfulGateway)testingRestfulGateway).get()).getTriggerId();
        AsynchronousOperationResult savepointResponseBody = (AsynchronousOperationResult)this.savepointStatusHandler.handleRequest(StopWithSavepointHandlersTest.savepointStatusRequest(triggerId), (RestfulGateway)testingRestfulGateway).get();
        Assert.assertThat((Object)savepointResponseBody.queueStatus().getId(), (Matcher)Matchers.equalTo((Object)QueueStatus.Id.COMPLETED));
        Assert.assertThat((Object)savepointResponseBody.resource(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((SavepointInfo)savepointResponseBody.resource()).getFailureCause(), (Matcher)Matchers.notNullValue());
        Throwable savepointError = ((SavepointInfo)savepointResponseBody.resource()).getFailureCause().deserializeError(ClassLoader.getSystemClassLoader());
        Assert.assertThat((Object)savepointError.getMessage(), (Matcher)Matchers.equalTo((Object)"expected"));
        Assert.assertThat((Object)savepointError, (Matcher)Matchers.instanceOf(RuntimeException.class));
    }

    private static HandlerRequest<StopWithSavepointRequestBody, SavepointTriggerMessageParameters> triggerSavepointRequest() throws HandlerRequestException {
        return StopWithSavepointHandlersTest.triggerSavepointRequest(DEFAULT_REQUESTED_SAVEPOINT_TARGET_DIRECTORY);
    }

    private static HandlerRequest<StopWithSavepointRequestBody, SavepointTriggerMessageParameters> triggerSavepointRequestWithDefaultDirectory() throws HandlerRequestException {
        return StopWithSavepointHandlersTest.triggerSavepointRequest(null);
    }

    private static HandlerRequest<StopWithSavepointRequestBody, SavepointTriggerMessageParameters> triggerSavepointRequest(String targetDirectory) throws HandlerRequestException {
        return new HandlerRequest((RequestBody)new StopWithSavepointRequestBody(targetDirectory, Boolean.valueOf(false)), (MessageParameters)new SavepointTriggerMessageParameters(), Collections.singletonMap("jobid", JOB_ID.toString()), Collections.emptyMap());
    }

    private static HandlerRequest<EmptyRequestBody, SavepointStatusMessageParameters> savepointStatusRequest(TriggerId triggerId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", JOB_ID.toString());
        pathParameters.put("triggerid", triggerId.toString());
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SavepointStatusMessageParameters(), pathParameters, Collections.emptyMap());
    }
}

