/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.util.Preconditions;

public class TestingTaskManagerInfo
implements TaskManagerInfo {
    private final TaskExecutorConnection taskExecutorConnection;
    private final ResourceProfile totalResource;
    private final ResourceProfile availableResource;
    private final ResourceProfile defaultSlotResourceProfile;
    private final int defaultNumSlots;

    public TestingTaskManagerInfo(ResourceProfile totalResource, ResourceProfile availableResource, ResourceProfile defaultSlotResourceProfile) {
        this.totalResource = (ResourceProfile)Preconditions.checkNotNull((Object)totalResource);
        this.availableResource = (ResourceProfile)Preconditions.checkNotNull((Object)availableResource);
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.defaultNumSlots = SlotManagerUtils.calculateDefaultNumSlots((ResourceProfile)totalResource, (ResourceProfile)defaultSlotResourceProfile);
        this.taskExecutorConnection = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());
    }

    public InstanceID getInstanceId() {
        return this.taskExecutorConnection.getInstanceID();
    }

    public TaskExecutorConnection getTaskExecutorConnection() {
        return this.taskExecutorConnection;
    }

    public Map<AllocationID, TaskManagerSlotInformation> getAllocatedSlots() {
        return Collections.emptyMap();
    }

    public ResourceProfile getAvailableResource() {
        return this.availableResource;
    }

    public ResourceProfile getTotalResource() {
        return this.totalResource;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public int getDefaultNumSlots() {
        return this.defaultNumSlots;
    }

    public long getIdleSince() {
        return Long.MAX_VALUE;
    }

    public boolean isIdle() {
        return false;
    }
}

