/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationResult;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerResourceInfoProvider;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.Preconditions;

public class TestingResourceAllocationStrategy
implements ResourceAllocationStrategy {
    private final BiFunction<Map<JobID, Collection<ResourceRequirement>>, TaskManagerResourceInfoProvider, ResourceAllocationResult> tryFulfillRequirementsFunction;

    private TestingResourceAllocationStrategy(BiFunction<Map<JobID, Collection<ResourceRequirement>>, TaskManagerResourceInfoProvider, ResourceAllocationResult> tryFulfillRequirementsFunction) {
        this.tryFulfillRequirementsFunction = (BiFunction)Preconditions.checkNotNull(tryFulfillRequirementsFunction);
    }

    public ResourceAllocationResult tryFulfillRequirements(Map<JobID, Collection<ResourceRequirement>> missingResources, TaskManagerResourceInfoProvider taskManagerResourceInfoProvider) {
        return this.tryFulfillRequirementsFunction.apply(missingResources, taskManagerResourceInfoProvider);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private BiFunction<Map<JobID, Collection<ResourceRequirement>>, TaskManagerResourceInfoProvider, ResourceAllocationResult> tryFulfillRequirementsFunction = (ignored0, ignored1) -> ResourceAllocationResult.builder().build();

        public Builder setTryFulfillRequirementsFunction(BiFunction<Map<JobID, Collection<ResourceRequirement>>, TaskManagerResourceInfoProvider, ResourceAllocationResult> tryFulfillRequirementsFunction) {
            this.tryFulfillRequirementsFunction = tryFulfillRequirementsFunction;
            return this;
        }

        public TestingResourceAllocationStrategy build() {
            return new TestingResourceAllocationStrategy(this.tryFulfillRequirementsFunction);
        }
    }
}

