/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.active.PendingWorkerCounter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class PendingWorkerCounterTest
extends TestLogger {
    @Test
    public void testPendingWorkerCounterIncreaseAndDecrease() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(2.0).build();
        PendingWorkerCounter counter = new PendingWorkerCounter();
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.increaseAndGet(spec1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.increaseAndGet(spec1), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.increaseAndGet(spec2), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.decreaseAndGet(spec1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.decreaseAndGet(spec2), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)counter.getTotalNum(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getNum(spec1), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)counter.getNum(spec2), (Matcher)Is.is((Object)0));
    }

    @Test(expected=IllegalStateException.class)
    public void testPendingWorkerCounterDecreaseOnZero() {
        WorkerResourceSpec spec = new WorkerResourceSpec.Builder().build();
        PendingWorkerCounter counter = new PendingWorkerCounter();
        counter.decreaseAndGet(spec);
    }
}

