/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.GroupReduceCombineDriver;
import org.apache.flink.runtime.operators.testutils.UnaryOperatorTestBase;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.apache.flink.runtime.operators.testutils.UnionIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class CombinerOversizedRecordsTest
extends UnaryOperatorTestBase<GroupCombineFunction<Tuple3<Integer, Integer, String>, Tuple3<Integer, Double, String>>, Tuple3<Integer, Integer, String>, Tuple3<Integer, Double, String>> {
    private static final long COMBINE_MEM = 0x300000L;
    private final double combine_frac;
    private final ArrayList<Tuple3<Integer, Double, String>> outList = new ArrayList();
    private final TypeSerializer<Tuple3<Integer, Integer, String>> serializer = new TupleSerializer(Tuple3.class, new TypeSerializer[]{IntSerializer.INSTANCE, IntSerializer.INSTANCE, StringSerializer.INSTANCE});
    private final TypeSerializer<Tuple3<Integer, Double, String>> outSerializer = new TupleSerializer(Tuple3.class, new TypeSerializer[]{IntSerializer.INSTANCE, DoubleSerializer.INSTANCE, StringSerializer.INSTANCE});
    private final TypeComparator<Tuple3<Integer, Integer, String>> comparator = new TupleComparator(new int[]{0}, new TypeComparator[]{new IntComparator(true)}, new TypeSerializer[]{IntSerializer.INSTANCE});

    public CombinerOversizedRecordsTest(ExecutionConfig config) {
        super(config, 0x300000L, 0);
        this.combine_frac = 3145728.0 / (double)this.getMemoryManager().getMemorySize();
    }

    @Test
    public void testOversizedRecordCombineTask() {
        try {
            int keyCnt = 100;
            int valCnt = 20;
            StringBuilder bld = new StringBuilder(0xA00000);
            Random rnd = new Random();
            for (int i = 0; i < 10000000; ++i) {
                bld.append((char)(rnd.nextInt(26) + 97));
            }
            String longString = bld.toString();
            bld = null;
            UniformIntTupleGenerator gen1 = new UniformIntTupleGenerator(100, 20, false);
            UniformIntTupleGenerator gen2 = new UniformIntTupleGenerator(100, 20, false);
            UnionIterator input = new UnionIterator(new SingleValueIterator(new Tuple3((Object)-1, (Object)-1, (Object)longString)), new StringIteratorDecorator(gen1), new SingleValueIterator(new Tuple3((Object)-1, (Object)-1, (Object)longString)), new StringIteratorDecorator(gen2), new SingleValueIterator(new Tuple3((Object)-1, (Object)-1, (Object)longString)));
            this.setInput(input, this.serializer);
            this.addDriverComparator(this.comparator);
            this.addDriverComparator(this.comparator);
            this.setOutput(this.outList, this.outSerializer);
            this.getTaskConfig().setDriverStrategy(DriverStrategy.SORTED_GROUP_COMBINE);
            this.getTaskConfig().setRelativeMemoryDriver(this.combine_frac);
            this.getTaskConfig().setFilehandlesDriver(2);
            GroupReduceCombineDriver testTask = new GroupReduceCombineDriver();
            this.testDriver((Driver)testTask, TestCombiner.class);
            Assert.assertEquals((long)3L, (long)testTask.getOversizedRecordCount());
            Assert.assertTrue((103 == this.outList.size() || 203 == this.outList.size() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class SingleValueIterator<T>
    implements MutableObjectIterator<T> {
        private final T value;
        private boolean pending = true;

        private SingleValueIterator(T value) {
            this.value = value;
        }

        public T next(T reuse) {
            return this.next();
        }

        public T next() {
            if (this.pending) {
                this.pending = false;
                return this.value;
            }
            return null;
        }
    }

    private static class StringIteratorDecorator
    implements MutableObjectIterator<Tuple3<Integer, Integer, String>> {
        private final MutableObjectIterator<Tuple2<Integer, Integer>> input;

        private StringIteratorDecorator(MutableObjectIterator<Tuple2<Integer, Integer>> input) {
            this.input = input;
        }

        public Tuple3<Integer, Integer, String> next(Tuple3<Integer, Integer, String> reuse) throws IOException {
            Tuple2 next = (Tuple2)this.input.next();
            if (next == null) {
                return null;
            }
            reuse.f0 = next.f0;
            reuse.f1 = next.f1;
            reuse.f2 = "test string";
            return reuse;
        }

        public Tuple3<Integer, Integer, String> next() throws IOException {
            Tuple2 next = (Tuple2)this.input.next();
            if (next == null) {
                return null;
            }
            return new Tuple3(next.f0, next.f1, (Object)"test string");
        }
    }

    public static final class TestCombiner
    implements GroupCombineFunction<Tuple3<Integer, Integer, String>, Tuple3<Integer, Double, String>> {
        private static final long serialVersionUID = 1L;

        public void combine(Iterable<Tuple3<Integer, Integer, String>> values, Collector<Tuple3<Integer, Double, String>> out) {
            int key = 0;
            int sum = 0;
            String someString = null;
            for (Tuple3<Integer, Integer, String> next : values) {
                key = (Integer)next.f0;
                sum += ((Integer)next.f1).intValue();
                someString = (String)next.f2;
            }
            out.collect((Object)new Tuple3((Object)key, (Object)sum, someString));
        }
    }
}

