/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.time.Duration;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SettableLeaderRetrievalServiceTest
extends TestLogger {
    private SettableLeaderRetrievalService settableLeaderRetrievalService;
    private static final Duration TIMEOUT = Duration.ofHours(1L);

    @Before
    public void setUp() {
        this.settableLeaderRetrievalService = new SettableLeaderRetrievalService();
    }

    @Test
    public void testNotifyListenerLater() throws Exception {
        String localhost = "localhost";
        this.settableLeaderRetrievalService.notifyListener("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingListener listener = new TestingListener();
        this.settableLeaderRetrievalService.start(listener);
        listener.waitForNewLeader(TIMEOUT.toMillis());
        Assert.assertThat((Object)listener.getAddress(), (Matcher)Matchers.equalTo((Object)"localhost"));
        Assert.assertThat((Object)listener.getLeaderSessionID(), (Matcher)Matchers.equalTo((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
    }

    @Test
    public void testNotifyListenerImmediately() throws Exception {
        TestingListener listener = new TestingListener();
        this.settableLeaderRetrievalService.start(listener);
        String localhost = "localhost";
        this.settableLeaderRetrievalService.notifyListener("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        listener.waitForNewLeader(TIMEOUT.toMillis());
        Assert.assertThat((Object)listener.getAddress(), (Matcher)Matchers.equalTo((Object)"localhost"));
        Assert.assertThat((Object)listener.getLeaderSessionID(), (Matcher)Matchers.equalTo((Object)HighAvailabilityServices.DEFAULT_LEADER_ID));
    }
}

