/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSlotPoolServiceSchedulerFactoryTest
extends TestLogger {
    @Test
    public void testFallsBackToDefaultSchedulerIfBatchJob() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)JobManagerOptions.SchedulerType.Adaptive);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.BATCH);
        Assert.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultSchedulerFactory.class)));
        Assert.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerType(), (Matcher)Matchers.is((Object)JobManagerOptions.SchedulerType.Ng));
    }

    @Test
    public void testAdaptiveSchedulerForReactiveMode() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER_MODE, (Object)SchedulerExecutionMode.REACTIVE);
        DefaultSlotPoolServiceSchedulerFactory defaultSlotPoolServiceSchedulerFactory = DefaultSlotPoolServiceSchedulerFactory.fromConfiguration((Configuration)configuration, (JobType)JobType.STREAMING);
        Assert.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerNGFactory(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(AdaptiveSchedulerFactory.class)));
        Assert.assertThat((Object)defaultSlotPoolServiceSchedulerFactory.getSchedulerType(), (Matcher)Matchers.is((Object)JobManagerOptions.SchedulerType.Adaptive));
    }
}

