/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class SubpartitionTestBase
extends TestLogger {
    abstract ResultSubpartition createSubpartition() throws Exception;

    abstract ResultSubpartition createFailingWritesSubpartition() throws Exception;

    @Test
    public void createReaderAfterDispose() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        subpartition.release();
        try {
            subpartition.createReadView(() -> {});
            Assert.fail((String)"expected an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAfterFinish() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.finish();
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklogUnsafe());
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
            Assert.assertEquals((long)-1L, (long)subpartition.add(bufferConsumer));
            Assert.assertTrue((boolean)bufferConsumer.isRecycled());
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklogUnsafe());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testAddAfterRelease() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.release();
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
            Assert.assertEquals((long)-1L, (long)subpartition.add(bufferConsumer));
            Assert.assertTrue((boolean)bufferConsumer.isRecycled());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testReleasingReaderDoesNotReleasePartition() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        ResultSubpartitionView reader = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
        Assert.assertFalse((boolean)partition.isReleased());
        Assert.assertFalse((boolean)reader.isReleased());
        reader.releaseAllResources();
        Assert.assertTrue((boolean)reader.isReleased());
        Assert.assertFalse((boolean)partition.isReleased());
        partition.release();
    }

    @Test
    public void testReleaseIsIdempotent() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        partition.release();
        partition.release();
        partition.release();
    }

    @Test
    public void testReadAfterDispose() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        ResultSubpartitionView reader = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
        reader.releaseAllResources();
        reader.getNextBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecycleBufferAndConsumerOnFailure() throws Exception {
        ResultSubpartition subpartition = this.createFailingWritesSubpartition();
        try {
            BufferConsumer consumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(100);
            try {
                subpartition.add(consumer);
                subpartition.flush();
                Assert.fail((String)"should fail with an exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertTrue((boolean)consumer.isRecycled());
        }
        finally {
            subpartition.release();
        }
    }
}

