/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.UUID;
import junit.framework.TestCase;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.TestingLeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EmbeddedHaServicesTest
extends TestLogger {
    private static final String ADDRESS = "foobar";
    private EmbeddedHaServices embeddedHaServices;

    @Before
    public void setupTest() {
        this.embeddedHaServices = new EmbeddedHaServices(Executors.directExecutor());
    }

    @After
    public void teardownTest() throws Exception {
        if (this.embeddedHaServices != null) {
            this.embeddedHaServices.closeAndCleanupAllData();
            this.embeddedHaServices = null;
        }
    }

    @Test
    public void testJobManagerLeaderElection() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContenderDifferentJobId = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElectionService leaderElectionService1 = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId1);
        LeaderElectionService leaderElectionService2 = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId1);
        LeaderElectionService leaderElectionServiceDifferentJobId = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId2);
        leaderElectionService1.start(leaderContender1);
        leaderElectionService2.start(leaderContender2);
        leaderElectionServiceDifferentJobId.start(leaderContenderDifferentJobId);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
        ((LeaderContender)Mockito.verify((Object)leaderContenderDifferentJobId)).grantLeadership((UUID)org.mockito.Matchers.any(UUID.class));
    }

    @Test
    public void testResourceManagerLeaderElection() throws Exception {
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElectionService leaderElectionService1 = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        LeaderElectionService leaderElectionService2 = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        leaderElectionService1.start(leaderContender1);
        leaderElectionService2.start(leaderContender2);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
    }

    @Test
    public void testJobManagerLeaderRetrieval() throws Exception {
        JobID jobId = new JobID();
        LeaderElectionService leaderElectionService = this.embeddedHaServices.getJobManagerLeaderElectionService(jobId);
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getJobManagerLeaderRetriever(jobId);
        this.runLeaderRetrievalTest(leaderElectionService, leaderRetrievalService);
    }

    private void runLeaderRetrievalTest(LeaderElectionService leaderElectionService, LeaderRetrievalService leaderRetrievalService) throws Exception {
        LeaderRetrievalUtils.LeaderConnectionInfoListener leaderRetrievalListener = new LeaderRetrievalUtils.LeaderConnectionInfoListener();
        TestingLeaderContender leaderContender = new TestingLeaderContender();
        leaderRetrievalService.start((LeaderRetrievalListener)leaderRetrievalListener);
        leaderElectionService.start((LeaderContender)leaderContender);
        UUID leaderId = leaderContender.getLeaderSessionFuture().get();
        leaderElectionService.confirmLeadership(leaderId, ADDRESS);
        LeaderConnectionInfo leaderConnectionInfo = (LeaderConnectionInfo)leaderRetrievalListener.getLeaderConnectionInfoFuture().get();
        Assert.assertThat((Object)leaderConnectionInfo.getAddress(), (Matcher)Matchers.is((Object)ADDRESS));
        Assert.assertThat((Object)leaderConnectionInfo.getLeaderSessionId(), (Matcher)Matchers.is((Object)leaderId));
    }

    @Test
    public void testResourceManagerLeaderRetrieval() throws Exception {
        LeaderElectionService leaderElectionService = this.embeddedHaServices.getResourceManagerLeaderElectionService();
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getResourceManagerLeaderRetriever();
        this.runLeaderRetrievalTest(leaderElectionService, leaderRetrievalService);
    }

    @Test
    public void testConcurrentLeadershipOperations() throws Exception {
        LeaderElectionService dispatcherLeaderElectionService = this.embeddedHaServices.getDispatcherLeaderElectionService();
        TestingLeaderContender leaderContender = new TestingLeaderContender();
        dispatcherLeaderElectionService.start((LeaderContender)leaderContender);
        UUID oldLeaderSessionId = leaderContender.getLeaderSessionFuture().get();
        Assert.assertThat((Object)dispatcherLeaderElectionService.hasLeadership(oldLeaderSessionId), (Matcher)Matchers.is((Object)true));
        this.embeddedHaServices.getDispatcherLeaderService().revokeLeadership().get();
        Assert.assertThat((Object)dispatcherLeaderElectionService.hasLeadership(oldLeaderSessionId), (Matcher)Matchers.is((Object)false));
        this.embeddedHaServices.getDispatcherLeaderService().grantLeadership();
        UUID newLeaderSessionId = leaderContender.getLeaderSessionFuture().get();
        Assert.assertThat((Object)dispatcherLeaderElectionService.hasLeadership(newLeaderSessionId), (Matcher)Matchers.is((Object)true));
        dispatcherLeaderElectionService.confirmLeadership(oldLeaderSessionId, ADDRESS);
        dispatcherLeaderElectionService.confirmLeadership(newLeaderSessionId, ADDRESS);
        Assert.assertThat((Object)dispatcherLeaderElectionService.hasLeadership(newLeaderSessionId), (Matcher)Matchers.is((Object)true));
        leaderContender.tryRethrowException();
    }
}

