/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Objects;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.junit.Assert;
import org.junit.Test;

public class EdgeManagerTest {
    @Test
    public void testGetConsumedPartitionGroup() throws Exception {
        JobVertex v1 = new JobVertex("source");
        JobVertex v2 = new JobVertex("sink");
        v1.setParallelism(2);
        v2.setParallelism(2);
        v1.setInvokableClass(NoOpInvokable.class);
        v2.setInvokableClass(NoOpInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING);
        JobGraph jobGraph = JobGraphTestUtils.batchJobGraph(v1, v2);
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(jobGraph, ComponentMainThreadExecutorServiceAdapter.forMainThread());
        ExecutionGraph eg = scheduler.getExecutionGraph();
        ConsumedPartitionGroup groupRetrievedByDownstreamVertex = (ConsumedPartitionGroup)Objects.requireNonNull(eg.getJobVertex(v2.getID())).getTaskVertices()[0].getAllConsumedPartitionGroups().get(0);
        IntermediateResultPartition consumedPartition = Objects.requireNonNull(eg.getJobVertex(v1.getID())).getProducedDataSets()[0].getPartitions()[0];
        ConsumedPartitionGroup groupRetrievedByIntermediateResultPartition = (ConsumedPartitionGroup)consumedPartition.getConsumedPartitionGroups().get(0);
        Assert.assertEquals((Object)groupRetrievedByDownstreamVertex, (Object)groupRetrievedByIntermediateResultPartition);
        ConsumedPartitionGroup groupRetrievedByScheduledResultPartition = (ConsumedPartitionGroup)scheduler.getExecutionGraph().getSchedulingTopology().getResultPartition(consumedPartition.getPartitionId()).getConsumedPartitionGroups().get(0);
        Assert.assertEquals((Object)groupRetrievedByDownstreamVertex, (Object)groupRetrievedByScheduledResultPartition);
    }
}

