/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounterTestBase;
import org.apache.flink.runtime.checkpoint.DefaultLastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.LastStateConnectionStateListener;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointIDCounter;
import org.apache.flink.runtime.zookeeper.ZooKeeperTestEnvironment;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperCheckpointIDCounterITCase
extends CheckpointIDCounterTestBase {
    private static final ZooKeeperTestEnvironment ZooKeeper = new ZooKeeperTestEnvironment(1);

    @AfterClass
    public static void tearDown() throws Exception {
        ZooKeeper.shutdown();
    }

    @Before
    public void cleanUp() throws Exception {
        ZooKeeper.deleteAll();
    }

    @Test
    public void testShutdownRemovesState() throws Exception {
        ZooKeeperCheckpointIDCounter counter = this.createCheckpointIdCounter();
        counter.start();
        CuratorFramework client = ZooKeeper.getClient();
        Assert.assertNotNull((Object)client.checkExists().forPath(counter.getPath()));
        counter.shutdown(JobStatus.FINISHED);
        Assert.assertNull((Object)client.checkExists().forPath(counter.getPath()));
    }

    @Test
    public void testSuspendKeepsState() throws Exception {
        ZooKeeperCheckpointIDCounter counter = this.createCheckpointIdCounter();
        counter.start();
        CuratorFramework client = ZooKeeper.getClient();
        Assert.assertNotNull((Object)client.checkExists().forPath(counter.getPath()));
        counter.shutdown(JobStatus.SUSPENDED);
        Assert.assertNotNull((Object)client.checkExists().forPath(counter.getPath()));
    }

    protected ZooKeeperCheckpointIDCounter createCheckpointIdCounter() throws Exception {
        return new ZooKeeperCheckpointIDCounter(ZooKeeper.getClient(), (LastStateConnectionStateListener)new DefaultLastStateConnectionStateListener());
    }
}

