/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.TestingCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.TestingCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.TestingCompletedCheckpointStore;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSchedulerCheckpointCoordinatorTest
extends TestLogger {
    @Test
    public void testClosingSchedulerShutsDownCheckpointCoordinatorOnFailedExecutionGraph() throws Exception {
        CompletableFuture<JobStatus> counterShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCheckpointIDCounter counter = new TestingCheckpointIDCounter(counterShutdownFuture);
        CompletableFuture<JobStatus> storeShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCompletedCheckpointStore store = new TestingCompletedCheckpointStore(storeShutdownFuture);
        DefaultScheduler scheduler = this.createSchedulerAndEnableCheckpointing(counter, store);
        ExecutionGraph graph = scheduler.getExecutionGraph();
        CheckpointCoordinator checkpointCoordinator = graph.getCheckpointCoordinator();
        Assert.assertThat((Object)checkpointCoordinator, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)false));
        graph.failJob((Throwable)new Exception("Test Exception"), System.currentTimeMillis());
        scheduler.closeAsync().get();
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)counterShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
        Assert.assertThat((Object)storeShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
    }

    @Test
    public void testClosingSchedulerShutsDownCheckpointCoordinatorOnSuspendedExecutionGraph() throws Exception {
        CompletableFuture<JobStatus> counterShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCheckpointIDCounter counter = new TestingCheckpointIDCounter(counterShutdownFuture);
        CompletableFuture<JobStatus> storeShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCompletedCheckpointStore store = new TestingCompletedCheckpointStore(storeShutdownFuture);
        DefaultScheduler scheduler = this.createSchedulerAndEnableCheckpointing(counter, store);
        ExecutionGraph graph = scheduler.getExecutionGraph();
        CheckpointCoordinator checkpointCoordinator = graph.getCheckpointCoordinator();
        Assert.assertThat((Object)checkpointCoordinator, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)false));
        graph.suspend((Throwable)new Exception("Test Exception"));
        scheduler.closeAsync().get();
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)counterShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED));
        Assert.assertThat((Object)storeShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED));
    }

    @Test
    public void testClosingSchedulerShutsDownCheckpointCoordinatorOnFinishedExecutionGraph() throws Exception {
        CompletableFuture<JobStatus> counterShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCheckpointIDCounter counter = new TestingCheckpointIDCounter(counterShutdownFuture);
        CompletableFuture<JobStatus> storeShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCompletedCheckpointStore store = new TestingCompletedCheckpointStore(storeShutdownFuture);
        DefaultScheduler scheduler = this.createSchedulerAndEnableCheckpointing(counter, store);
        ExecutionGraph graph = scheduler.getExecutionGraph();
        CheckpointCoordinator checkpointCoordinator = graph.getCheckpointCoordinator();
        Assert.assertThat((Object)checkpointCoordinator, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)false));
        scheduler.startScheduling();
        for (ExecutionVertex executionVertex : graph.getAllExecutionVertices()) {
            Execution currentExecutionAttempt = executionVertex.getCurrentExecutionAttempt();
            scheduler.updateTaskExecutionState(new TaskExecutionState(currentExecutionAttempt.getAttemptId(), ExecutionState.FINISHED));
        }
        Assert.assertThat(graph.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
        scheduler.closeAsync().get();
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)counterShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
        Assert.assertThat((Object)storeShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
    }

    @Test
    public void testClosingSchedulerSuspendsExecutionGraphAndShutsDownCheckpointCoordinator() throws Exception {
        CompletableFuture<JobStatus> counterShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCheckpointIDCounter counter = new TestingCheckpointIDCounter(counterShutdownFuture);
        CompletableFuture<JobStatus> storeShutdownFuture = new CompletableFuture<JobStatus>();
        TestingCompletedCheckpointStore store = new TestingCompletedCheckpointStore(storeShutdownFuture);
        DefaultScheduler scheduler = this.createSchedulerAndEnableCheckpointing(counter, store);
        ExecutionGraph graph = scheduler.getExecutionGraph();
        CheckpointCoordinator checkpointCoordinator = graph.getCheckpointCoordinator();
        Assert.assertThat((Object)checkpointCoordinator, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)false));
        scheduler.closeAsync().get();
        Assert.assertThat((Object)graph.getState(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED));
        Assert.assertThat((Object)checkpointCoordinator.isShutdown(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)counterShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED));
        Assert.assertThat((Object)storeShutdownFuture.get(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED));
    }

    private DefaultScheduler createSchedulerAndEnableCheckpointing(CheckpointIDCounter counter, CompletedCheckpointStore store) throws Exception {
        Time timeout = Time.days((long)1L);
        JobVertex jobVertex = new JobVertex("MockVertex");
        jobVertex.setInvokableClass(AbstractInvokable.class);
        CheckpointCoordinatorConfiguration chkConfig = CheckpointCoordinatorConfiguration.builder().setCheckpointInterval(100L).setCheckpointTimeout(100L).build();
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(chkConfig, null);
        JobGraph jobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertex(jobVertex).setJobCheckpointingSettings(checkpointingSettings).build();
        return SchedulerTestingUtils.newSchedulerBuilder(jobGraph, ComponentMainThreadExecutorServiceAdapter.forMainThread()).setCheckpointRecoveryFactory(new TestingCheckpointRecoveryFactory(store, counter)).setRpcTimeout(timeout).build();
    }
}

