/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CheckpointFailureManagerTest
extends TestLogger {
    @Test
    public void testIgnoresPastCheckpoints() throws IOException, JobException {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 2L);
        failureManager.handleCheckpointSuccess(2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 4L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testContinuousFailure() throws IOException, JobException {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 4L);
        Assert.assertEquals((long)1L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testBreakContinuousFailure() throws IOException, JobException {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.IO_EXCEPTION), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleCheckpointSuccess(4L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 5L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testTotalCountValue() throws IOException, JobException {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        CheckpointFailureManager failureManager = new CheckpointFailureManager(0, (CheckpointFailureManager.FailJobCallback)callback);
        for (CheckpointFailureReason reason : CheckpointFailureReason.values()) {
            failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(reason), -2L);
        }
        Assert.assertEquals((long)4L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testIgnoreOneCheckpointRepeatedlyCountMultiTimes() throws IOException, JobException {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testPendingCheckpointStatsCallbacks() throws Exception {
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)new TestFailJobCallback());
        PendingCheckpoint pendingCheckpoint = (PendingCheckpoint)Mockito.mock(PendingCheckpoint.class);
        PendingCheckpointStats pendingCheckpointCallback = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        CheckpointStatsTracker statsTracker = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        failureManager.handleCheckpointException(pendingCheckpoint, checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_SUBSUMED, null), null, new JobID(), pendingCheckpointCallback, statsTracker);
        ((PendingCheckpointStats)Mockito.verify((Object)pendingCheckpointCallback, (VerificationMode)Mockito.times((int)1))).reportFailedCheckpoint(ArgumentMatchers.anyLong(), (Throwable)ArgumentMatchers.any(Exception.class));
        ((CheckpointStatsTracker)Mockito.verify((Object)statsTracker, (VerificationMode)Mockito.times((int)0))).reportFailedCheckpointsWithoutInProgress();
        failureManager.handleCheckpointException(null, checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_SUBSUMED, null), null, new JobID(), null, statsTracker);
        ((PendingCheckpointStats)Mockito.verify((Object)pendingCheckpointCallback, (VerificationMode)Mockito.times((int)1))).reportFailedCheckpoint(ArgumentMatchers.anyLong(), (Throwable)ArgumentMatchers.any(Exception.class));
        ((CheckpointStatsTracker)Mockito.verify((Object)statsTracker, (VerificationMode)Mockito.times((int)1))).reportFailedCheckpointsWithoutInProgress();
    }

    private static class TestFailJobCallback
    implements CheckpointFailureManager.FailJobCallback {
        private int invokeCounter = 0;

        private TestFailJobCallback() {
        }

        public void failJob(Throwable cause) {
            ++this.invokeCounter;
        }

        public void failJobDueToTaskFailure(Throwable cause, ExecutionAttemptID executionAttemptID) {
            ++this.invokeCounter;
        }

        public int getInvokeCounter() {
            return this.invokeCounter;
        }
    }
}

