/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStore;

public class TestingBlobStore
implements BlobStore {
    @Nonnull
    private final Function<Tuple3<File, JobID, BlobKey>, Boolean> putFunction;
    @Nonnull
    private final BiFunction<JobID, BlobKey, Boolean> deleteFunction;
    @Nonnull
    private final Function<JobID, Boolean> deleteAllFunction;
    @Nonnull
    private final Function<Tuple3<JobID, BlobKey, File>, Boolean> getFunction;

    public TestingBlobStore(@Nonnull Function<Tuple3<File, JobID, BlobKey>, Boolean> putFunction, @Nonnull BiFunction<JobID, BlobKey, Boolean> deleteFunction, @Nonnull Function<JobID, Boolean> deleteAllFunction, @Nonnull Function<Tuple3<JobID, BlobKey, File>, Boolean> getFunction) {
        this.putFunction = putFunction;
        this.deleteFunction = deleteFunction;
        this.deleteAllFunction = deleteAllFunction;
        this.getFunction = getFunction;
    }

    public boolean put(File localFile, JobID jobId, BlobKey blobKey) {
        return this.putFunction.apply((Tuple3<File, JobID, BlobKey>)Tuple3.of((Object)localFile, (Object)jobId, (Object)blobKey));
    }

    public boolean delete(JobID jobId, BlobKey blobKey) {
        return this.deleteFunction.apply(jobId, blobKey);
    }

    public boolean deleteAll(JobID jobId) {
        return this.deleteAllFunction.apply(jobId);
    }

    public boolean get(JobID jobId, BlobKey blobKey, File localFile) {
        return this.getFunction.apply((Tuple3<JobID, BlobKey, File>)Tuple3.of((Object)jobId, (Object)blobKey, (Object)localFile));
    }
}

