/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BlobServerPutTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testServerContentAddressableGetStorageLocationConcurrentNoJob() throws Exception {
        this.testServerContentAddressableGetStorageLocationConcurrent(null);
    }

    @Test
    public void testServerContentAddressableGetStorageLocationConcurrentForJob() throws Exception {
        this.testServerContentAddressableGetStorageLocationConcurrent(new JobID());
    }

    private void testServerContentAddressableGetStorageLocationConcurrent(@Nullable JobID jobId) throws Exception {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            TransientBlobKey key1 = new TransientBlobKey();
            PermanentBlobKey key2 = new PermanentBlobKey();
            CheckedThread[] threads = new CheckedThread[]{new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key1), new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key1), new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key1), new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key2), new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key2), new ContentAddressableGetStorageLocation(server, jobId, (BlobKey)key2)};
            this.checkedThreadSimpleTest(threads);
        }
    }

    private void checkedThreadSimpleTest(CheckedThread[] threads) throws Exception {
        for (CheckedThread t : threads) {
            t.start();
        }
        for (CheckedThread t : threads) {
            t.sync();
        }
    }

    @Test
    public void testPutBufferSuccessfulGet1() throws IOException {
        this.testPutBufferSuccessfulGet(null, null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferSuccessfulGet2() throws IOException {
        this.testPutBufferSuccessfulGet(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferSuccessfulGet3() throws IOException {
        this.testPutBufferSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferSuccessfulGet4() throws IOException {
        this.testPutBufferSuccessfulGet(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferSuccessfulGetHa() throws IOException {
        this.testPutBufferSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testPutBufferSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            BlobKey key1a = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            Assert.assertNotNull((Object)key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key1a2);
            BlobKey key1b = BlobServerPutTest.put((BlobService)server, jobId1, data2, blobType);
            Assert.assertNotNull((Object)key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobKey key2a = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key2a);
            BlobKey key2b = BlobServerPutTest.put((BlobService)server, jobId2, data2, blobType);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1b, key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
        }
    }

    @Test
    public void testPutStreamSuccessfulGet1() throws IOException {
        this.testPutStreamSuccessfulGet(null, null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutStreamSuccessfulGet2() throws IOException {
        this.testPutStreamSuccessfulGet(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutStreamSuccessfulGet3() throws IOException {
        this.testPutStreamSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutStreamSuccessfulGet4() throws IOException {
        this.testPutStreamSuccessfulGet(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutStreamSuccessfulGetHa() throws IOException {
        this.testPutStreamSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testPutStreamSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            BlobKey key1a = BlobServerPutTest.put((BlobService)server, jobId1, new ByteArrayInputStream(data), blobType);
            Assert.assertNotNull((Object)key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)server, jobId1, new ByteArrayInputStream(data), blobType);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key1a2);
            BlobKey key1b = BlobServerPutTest.put((BlobService)server, jobId1, new ByteArrayInputStream(data2), blobType);
            Assert.assertNotNull((Object)key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobKey key2a = BlobServerPutTest.put((BlobService)server, jobId2, new ByteArrayInputStream(data), blobType);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key2a);
            BlobKey key2b = BlobServerPutTest.put((BlobService)server, jobId2, new ByteArrayInputStream(data2), blobType);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1b, key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
        }
    }

    @Test
    public void testPutChunkedStreamSuccessfulGet1() throws IOException {
        this.testPutChunkedStreamSuccessfulGet(null, null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutChunkedStreamSuccessfulGet2() throws IOException {
        this.testPutChunkedStreamSuccessfulGet(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutChunkedStreamSuccessfulGet3() throws IOException {
        this.testPutChunkedStreamSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutChunkedStreamSuccessfulGet4() throws IOException {
        this.testPutChunkedStreamSuccessfulGet(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutChunkedStreamSuccessfulGetHa() throws IOException {
        this.testPutChunkedStreamSuccessfulGet(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testPutChunkedStreamSuccessfulGet(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            byte[] data2 = Arrays.copyOfRange(data, 10, 54);
            BlobKey key1a = BlobServerPutTest.put((BlobService)server, jobId1, new ChunkedInputStream(data, 19), blobType);
            Assert.assertNotNull((Object)key1a);
            BlobKey key1a2 = BlobServerPutTest.put((BlobService)server, jobId1, new ChunkedInputStream(data, 19), blobType);
            Assert.assertNotNull((Object)key1a2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key1a2);
            BlobKey key1b = BlobServerPutTest.put((BlobService)server, jobId1, new ChunkedInputStream(data2, 19), blobType);
            Assert.assertNotNull((Object)key1b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobKey key2a = BlobServerPutTest.put((BlobService)server, jobId2, new ChunkedInputStream(data, 19), blobType);
            Assert.assertNotNull((Object)key2a);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1a, key2a);
            BlobKey key2b = BlobServerPutTest.put((BlobService)server, jobId2, new ChunkedInputStream(data2, 19), blobType);
            Assert.assertNotNull((Object)key2b);
            BlobKeyTest.verifyKeyDifferentHashEquals(key1b, key2b);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1a2, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId1, key1b, data2);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2a, data);
            BlobServerPutTest.verifyContents((BlobService)server, jobId2, key2b, data2);
        }
    }

    @Test
    public void testPutBufferFailsNoJob() throws IOException {
        this.testPutBufferFails(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsForJob() throws IOException {
        this.testPutBufferFails(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsForJobHa() throws IOException {
        this.testPutBufferFails(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFails(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File tempFileDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            tempFileDir = server.createTemporaryFilename().getParentFile().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(AccessDeniedException.class);
            BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testPutBufferFailsIncomingNoJob() throws IOException {
        this.testPutBufferFailsIncoming(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsIncomingForJob() throws IOException {
        this.testPutBufferFailsIncoming(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsIncomingForJobHa() throws IOException {
        this.testPutBufferFailsIncoming(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFailsIncoming(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File tempFileDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            File storageDir;
            server.start();
            tempFileDir = server.createTemporaryFilename().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(IOException.class);
            this.exception.expectMessage(" (Permission denied)");
            try {
                BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
                storageDir = tempFileDir.getParentFile();
            }
            catch (Throwable throwable) {
                File storageDir2 = tempFileDir.getParentFile();
                Assert.assertArrayEquals((Object[])new String[]{"incoming"}, (Object[])storageDir2.list());
                throw throwable;
            }
            Assert.assertArrayEquals((Object[])new String[]{"incoming"}, (Object[])storageDir.list());
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testPutBufferFailsStoreNoJob() throws IOException {
        this.testPutBufferFailsStore(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsStoreForJob() throws IOException {
        this.testPutBufferFailsStore(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testPutBufferFailsStoreForJobHa() throws IOException {
        this.testPutBufferFailsStore(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutBufferFailsStore(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File jobStoreDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            jobStoreDir = server.getStorageLocation(jobId, BlobKey.createKey((BlobKey.BlobType)blobType)).getParentFile();
            Assert.assertTrue((boolean)jobStoreDir.setExecutable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setReadable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setWritable(false, false));
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            this.exception.expect(AccessDeniedException.class);
            try {
                BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            }
            finally {
                File incomingFileDir = new File(jobStoreDir.getParent(), "incoming");
                Assert.assertArrayEquals((Object[])new String[0], (Object[])incomingFileDir.list());
                Assert.assertArrayEquals((Object[])new String[0], (Object[])jobStoreDir.list());
            }
        }
        finally {
            if (jobStoreDir != null) {
                jobStoreDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testConcurrentPutOperationsNoJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentPutOperationsForJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentPutOperationsForJobHa() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentPutOperations(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentPutOperations(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException, InterruptedException, ExecutionException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobStore blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        int concurrentPutOperations = 2;
        int dataSize = 1024;
        CountDownLatch countDownLatch = new CountDownLatch(concurrentPutOperations);
        byte[] data = new byte[dataSize];
        ArrayList<CompletableFuture<BlobKey>> allFutures = new ArrayList<CompletableFuture<BlobKey>>(concurrentPutOperations);
        ExecutorService executor = Executors.newFixedThreadPool(concurrentPutOperations);
        try (BlobServer server = new BlobServer(config, blobStore);){
            server.start();
            for (int i = 0; i < concurrentPutOperations; ++i) {
                CompletableFuture<BlobKey> putFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        BlockingInputStream inputStream = new BlockingInputStream(countDownLatch, data);
                        BlobKey uploadedKey = BlobServerPutTest.put((BlobService)server, jobId, inputStream, blobType);
                        BlobServerPutTest.verifyContents((BlobService)server, jobId, uploadedKey, data);
                        return uploadedKey;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not upload blob.", (Throwable)e));
                    }
                }, executor);
                allFutures.add(putFuture);
            }
            FutureUtils.ConjunctFuture conjunctFuture = FutureUtils.combineAll(allFutures);
            Collection blobKeys = (Collection)conjunctFuture.get();
            Iterator blobKeyIterator = blobKeys.iterator();
            Assert.assertTrue((boolean)blobKeyIterator.hasNext());
            BlobKey blobKey = (BlobKey)blobKeyIterator.next();
            while (blobKeyIterator.hasNext()) {
                BlobKeyTest.verifyKeyDifferentHashEquals(blobKey, (BlobKey)blobKeyIterator.next());
            }
            BlobServerPutTest.verifyContents((BlobService)server, jobId, blobKey, data);
            if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
                ((BlobStore)Mockito.verify((Object)blobStore, (VerificationMode)Mockito.times((int)1))).put((File)Matchers.any(File.class), (JobID)Matchers.eq((Object)jobId), (BlobKey)Matchers.eq((Object)blobKey));
            } else {
                ((BlobStore)Mockito.verify((Object)blobStore, (VerificationMode)Mockito.times((int)0))).put((File)Matchers.any(File.class), (JobID)Matchers.eq((Object)jobId), (BlobKey)Matchers.eq((Object)blobKey));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    static BlobKey put(BlobService service, @Nullable JobID jobId, InputStream data, BlobKey.BlobType blobType) throws IOException {
        if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
            if (service instanceof BlobServer) {
                return ((BlobServer)service).putPermanent(jobId, data);
            }
            throw new UnsupportedOperationException("uploading streams is only possible at the BlobServer");
        }
        if (jobId == null) {
            return service.getTransientBlobService().putTransient(data);
        }
        return service.getTransientBlobService().putTransient(jobId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BlobKey put(BlobService service, @Nullable JobID jobId, byte[] data, BlobKey.BlobType blobType) throws IOException {
        if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
            if (service instanceof BlobServer) {
                return ((BlobServer)service).putPermanent(jobId, data);
            }
            File tmpFile = Files.createTempFile("blob", ".jar", new FileAttribute[0]).toFile();
            try {
                FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data);
                InetSocketAddress serverAddress = new InetSocketAddress("localhost", service.getPort());
                Configuration clientConfig = new Configuration();
                List<Path> jars = Collections.singletonList(new Path(tmpFile.getAbsolutePath()));
                List keys = BlobClient.uploadFiles((InetSocketAddress)serverAddress, (Configuration)clientConfig, (JobID)jobId, jars);
                Assert.assertEquals((long)1L, (long)keys.size());
                BlobKey blobKey = (BlobKey)keys.get(0);
                return blobKey;
            }
            finally {
                tmpFile.delete();
            }
        }
        if (jobId == null) {
            return service.getTransientBlobService().putTransient(data);
        }
        return service.getTransientBlobService().putTransient(jobId, data);
    }

    static void verifyContents(BlobService blobService, @Nullable JobID jobId, BlobKey key, byte[] data) throws IOException {
        File file = BlobServerGetTest.get(blobService, jobId, key);
        BlobClientTest.validateGetAndClose((InputStream)new FileInputStream(file), data);
    }

    static void verifyContents(BlobService blobService, @Nullable JobID jobId, BlobKey key, InputStream data) throws IOException {
        File file = BlobServerGetTest.get(blobService, jobId, key);
        BlobClientTest.validateGetAndClose((InputStream)new FileInputStream(file), data);
    }

    static final class ChunkedInputStream
    extends InputStream {
        private final byte[][] data;
        private int x = 0;
        private int y = 0;

        ChunkedInputStream(byte[] data, int numChunks) {
            this.data = new byte[numChunks][];
            int bytesPerChunk = data.length / numChunks;
            int bytesTaken = 0;
            int i = 0;
            while (i < numChunks - 1) {
                this.data[i] = new byte[bytesPerChunk];
                System.arraycopy(data, bytesTaken, this.data[i], 0, bytesPerChunk);
                ++i;
                bytesTaken += bytesPerChunk;
            }
            this.data[numChunks - 1] = new byte[data.length - bytesTaken];
            System.arraycopy(data, bytesTaken, this.data[numChunks - 1], 0, this.data[numChunks - 1].length);
        }

        @Override
        public int read() {
            if (this.x < this.data.length) {
                byte[] curr = this.data[this.x];
                if (this.y < curr.length) {
                    byte next = curr[this.y];
                    ++this.y;
                    return next;
                }
                this.y = 0;
                ++this.x;
                return this.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.x < this.data.length) {
                byte[] curr = this.data[this.x];
                if (this.y < curr.length) {
                    int toCopy = Math.min(len, curr.length - this.y);
                    System.arraycopy(curr, this.y, b, off, toCopy);
                    this.y += toCopy;
                    return toCopy;
                }
                this.y = 0;
                ++this.x;
                return this.read(b, off, len);
            }
            return -1;
        }
    }

    static final class BlockingInputStream
    extends InputStream {
        private final CountDownLatch countDownLatch;
        private final byte[] data;
        private int index = 0;

        BlockingInputStream(CountDownLatch countDownLatch, byte[] data) {
            this.countDownLatch = (CountDownLatch)Preconditions.checkNotNull((Object)countDownLatch);
            this.data = (byte[])Preconditions.checkNotNull((Object)data);
        }

        @Override
        public int read() throws IOException {
            this.countDownLatch.countDown();
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Blocking operation was interrupted.", e);
            }
            if (this.index >= this.data.length) {
                return -1;
            }
            return this.data[this.index++];
        }
    }

    public static class ContentAddressableGetStorageLocation
    extends CheckedThread {
        private final BlobServer server;
        private final JobID jobId;
        private final BlobKey key;

        ContentAddressableGetStorageLocation(BlobServer server, @Nullable JobID jobId, BlobKey key) {
            this.server = server;
            this.jobId = jobId;
            this.key = key;
        }

        public void go() throws Exception {
            this.server.getStorageLocation(this.jobId, this.key);
        }
    }
}

