/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history.retaining;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.runtime.webmonitor.history.retaining.JobRetainedStrategy;
import org.apache.flink.runtime.webmonitor.history.retaining.QuantityJobRetainedStrategy;
import org.apache.flink.runtime.webmonitor.history.retaining.TimeToLiveJobRetainedStrategy;

public class CompositeJobRetainedStrategy
implements JobRetainedStrategy {
    private final List<JobRetainedStrategy> strategies;

    public static JobRetainedStrategy createFrom(ReadableConfig config) {
        int maxHistorySizeByOldKey = (Integer)config.get(HistoryServerOptions.HISTORY_SERVER_RETAINED_JOBS);
        Optional retainedTtlOpt = config.getOptional(HistoryServerOptions.HISTORY_SERVER_RETAINED_TTL);
        return new CompositeJobRetainedStrategy(new QuantityJobRetainedStrategy(maxHistorySizeByOldKey), new TimeToLiveJobRetainedStrategy(retainedTtlOpt.orElse(null)));
    }

    CompositeJobRetainedStrategy(JobRetainedStrategy ... strategies) {
        this.strategies = strategies == null || strategies.length == 0 ? Collections.emptyList() : Arrays.asList(strategies);
    }

    @Override
    public boolean shouldRetain(FileStatus file, int fileOrderedIndex) {
        if (this.strategies.isEmpty()) {
            return true;
        }
        return this.strategies.stream().allMatch(s -> s.shouldRetain(file, fileOrderedIndex));
    }
}

