/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.RecoveryClaimMode;
import org.apache.flink.runtime.webmonitor.handlers.JarRequestBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JarRunRequestBody
extends JarRequestBody {
    private static final String FIELD_NAME_ALLOW_NON_RESTORED_STATE = "allowNonRestoredState";
    private static final String FIELD_NAME_SAVEPOINT_PATH = "savepointPath";
    @Deprecated
    private static final String FIELD_NAME_SAVEPOINT_RESTORE_MODE = "restoreMode";
    private static final String FIELD_NAME_SAVEPOINT_CLAIM_MODE = "claimMode";
    @JsonProperty(value="allowNonRestoredState")
    @Nullable
    private Boolean allowNonRestoredState;
    @JsonProperty(value="savepointPath")
    @Nullable
    private String savepointPath;
    @JsonProperty(value="restoreMode")
    @Nullable
    @Deprecated
    @Documentation.ExcludeFromDocumentation
    private RecoveryClaimMode deprecatedRecoveryClaimMode;
    @JsonProperty(value="claimMode")
    @Nullable
    private RecoveryClaimMode recoveryClaimMode;

    public JarRunRequestBody() {
        this(null, null, null, null, null, null, null, null, null);
    }

    @VisibleForTesting
    public JarRunRequestBody(@Nullable String entryClassName, @Nullable List<String> programArgumentsList, @Nullable Integer parallelism, @Nullable JobID jobId, @Nullable Boolean allowNonRestoredState, @Nullable String savepointPath, @Nullable RecoveryClaimMode recoveryClaimMode, @Nullable Map<String, String> flinkConfiguration) {
        this(entryClassName, programArgumentsList, parallelism, jobId, allowNonRestoredState, savepointPath, null, recoveryClaimMode, flinkConfiguration);
    }

    @JsonCreator
    public JarRunRequestBody(@Nullable @JsonProperty(value="entryClass") String entryClassName, @Nullable @JsonProperty(value="programArgsList") List<String> programArgumentsList, @Nullable @JsonProperty(value="parallelism") Integer parallelism, @Nullable @JsonProperty(value="jobId") JobID jobId, @Nullable @JsonProperty(value="allowNonRestoredState") Boolean allowNonRestoredState, @Nullable @JsonProperty(value="savepointPath") String savepointPath, @Nullable @JsonProperty(value="restoreMode") RecoveryClaimMode deprecatedRecoveryClaimMode, @Nullable @JsonProperty(value="claimMode") RecoveryClaimMode recoveryClaimMode, @Nullable @JsonProperty(value="flinkConfiguration") Map<String, String> flinkConfiguration) {
        super(entryClassName, programArgumentsList, parallelism, jobId, flinkConfiguration);
        this.allowNonRestoredState = allowNonRestoredState;
        this.savepointPath = savepointPath;
        this.deprecatedRecoveryClaimMode = deprecatedRecoveryClaimMode;
        this.recoveryClaimMode = recoveryClaimMode;
    }

    @Nullable
    @JsonIgnore
    public Boolean getAllowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    @Nullable
    @JsonIgnore
    public String getSavepointPath() {
        return this.savepointPath;
    }

    @Nullable
    @JsonIgnore
    public RecoveryClaimMode getRecoveryClaimMode() {
        return this.recoveryClaimMode == null ? this.deprecatedRecoveryClaimMode : this.recoveryClaimMode;
    }

    @JsonIgnore
    public boolean isDeprecatedRestoreModeHasValue() {
        return this.deprecatedRecoveryClaimMode != null;
    }
}

