/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import com.typesafe.config.Config;
import org.apache.flink.runtime.rpc.pekko.PrioritySettingThreadFactory;
import org.apache.pekko.dispatch.DefaultDispatcherPrerequisites;
import org.apache.pekko.dispatch.DispatcherConfigurator;
import org.apache.pekko.dispatch.DispatcherPrerequisites;

public class PriorityThreadsDispatcher
extends DispatcherConfigurator {
    public PriorityThreadsDispatcher(Config config, DispatcherPrerequisites prerequisites) {
        super(config, PriorityThreadsDispatcher.createPriorityThreadDispatcherPrerequisites(prerequisites, config.getInt("thread-priority")));
    }

    private static DispatcherPrerequisites createPriorityThreadDispatcherPrerequisites(DispatcherPrerequisites prerequisites, int newThreadPriority) {
        return new DefaultDispatcherPrerequisites(new PrioritySettingThreadFactory(prerequisites.threadFactory(), newThreadPriority), prerequisites.eventStream(), prerequisites.scheduler(), prerequisites.dynamicAccess(), prerequisites.settings(), prerequisites.mailboxes(), prerequisites.defaultExecutionContext());
    }
}

