/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.pekko.io.DirectByteBufferPool$;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.EnvelopeBuffer$;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.HeaderBuilderImpl;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.Unsafe;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}vAB\u001c9\u0011\u0003Q$I\u0002\u0004Eq!\u0005!(\u0012\u0005\u0006\u0019\u0006!\tA\u0014\u0005\b\u001f\u0006\u0011\r\u0011\"\u0001Q\u0011\u0019!\u0016\u0001)A\u0005#\"9Q+\u0001b\u0001\n\u0003\u0001\u0006B\u0002,\u0002A\u0003%\u0011\u000bC\u0004X\u0003\t\u0007I\u0011\u0001-\t\rq\u000b\u0001\u0015!\u0003Z\u0011\u001di\u0016A1A\u0005\u0002ACaAX\u0001!\u0002\u0013\t\u0006bB0\u0002\u0005\u0004%\t\u0001\u0015\u0005\u0007A\u0006\u0001\u000b\u0011B)\t\u000f\u0005\f!\u0019!C\u0001!\"1!-\u0001Q\u0001\nECqaY\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004e\u0003\u0001\u0006I!\u0015\u0005\bK\u0006\u0011\r\u0011\"\u0001Q\u0011\u00191\u0017\u0001)A\u0005#\"9q-\u0001b\u0001\n\u0003\u0001\u0006B\u00025\u0002A\u0003%\u0011\u000bC\u0004j\u0003\t\u0007I\u0011\u0001)\t\r)\f\u0001\u0015!\u0003R\u0011\u001dY\u0017A1A\u0005\u0002ACa\u0001\\\u0001!\u0002\u0013\t\u0006bB7\u0002\u0005\u0004%\t\u0001\u0015\u0005\u0007]\u0006\u0001\u000b\u0011B)\t\u000f=\f!\u0019!C\u0001!\"1\u0001/\u0001Q\u0001\nE3Q\u0001\u0012\u001d\u0003uED\u0001B]\u000f\u0003\u0006\u0004%\ta\u001d\u0005\tyv\u0011\t\u0011)A\u0005i\")A*\bC\u0001{\"I\u0011\u0011A\u000fC\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003+i\u0002\u0015!\u0003\u0002\u0006!I\u0011qC\u000fA\u0002\u0013%\u0011\u0011\u0004\u0005\n\u0003Oi\u0002\u0019!C\u0005\u0003SA\u0001\"!\u000e\u001eA\u0003&\u00111\u0004\u0005\n\u0003oi\u0002\u0019!C\u0005\u0003sA\u0011\"a\u0011\u001e\u0001\u0004%I!!\u0012\t\u0011\u0005%S\u0004)Q\u0005\u0003wA\u0001\"a\u0013\u001e\u0001\u0004%I\u0001\u0015\u0005\n\u0003\u001bj\u0002\u0019!C\u0005\u0003\u001fBq!a\u0015\u001eA\u0003&\u0011\u000b\u0003\u0004\u0002Vu!\t\u0001\u0015\u0005\b\u0003/jB\u0011AA-\u0011\u001d\ty&\bC\u0001\u0003CBq!a\u0018\u001e\t\u0003\ti\u0007C\u0004\u0002|u!\t!! \t\u000f\u0005\u0005U\u0004\"\u0003\u0002\u0004\"9\u0011qT\u000f\u0005\n\u0005\u0005\u0006bBAR;\u0011%\u0011Q\u0015\u0005\b\u0003_kB\u0011BAY\u0011\u001d\t9,\bC\u0001\u0003sCq!a/\u001e\t\u0003\ti,\u0001\bF]Z,Gn\u001c9f\u0005V4g-\u001a:\u000b\u0005eR\u0014AB1si\u0016\u0014\u0018P\u0003\u0002<y\u00051!/Z7pi\u0016T!!\u0010 \u0002\u000bA,7n[8\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'o\u001a\t\u0003\u0007\u0006i\u0011\u0001\u000f\u0002\u000f\u000b:4X\r\\8qK\n+hMZ3s'\t\ta\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!)A\u0006UC\u001e$\u0016\u0010]3NCN\\W#A)\u0011\u0005\u001d\u0013\u0016BA*I\u0005\rIe\u000e^\u0001\r)\u0006<G+\u001f9f\u001b\u0006\u001c8\u000eI\u0001\r)\u0006<g+\u00197vK6\u000b7o[\u0001\u000e)\u0006<g+\u00197vK6\u000b7o\u001b\u0011\u0002'5+G/\u00193bi\u0006\u0004&/Z:f]R4E.Y4\u0016\u0003e\u0003\"a\u0011.\n\u0005mC$\u0001\u0003\"zi\u00164E.Y4\u0002)5+G/\u00193bi\u0006\u0004&/Z:f]R4E.Y4!\u000351VM]:j_:|eMZ:fi\u0006qa+\u001a:tS>twJ\u001a4tKR\u0004\u0013a\u0003$mC\u001e\u001cxJ\u001a4tKR\fAB\u00127bON|eMZ:fi\u0002\nQ%Q2u_J\u0014VMZ\"p[B\u0014Xm]:j_:$\u0016M\u00197f-\u0016\u00148/[8o\u001f\u001a47/\u001a;\u0002M\u0005\u001bGo\u001c:SK\u001a\u001cu.\u001c9sKN\u001c\u0018n\u001c8UC\ndWMV3sg&|gn\u00144gg\u0016$\b%\u0001\u0016DY\u0006\u001c8/T1oS\u001a,7\u000f^\"p[B\u0014Xm]:j_:$\u0016M\u00197f-\u0016\u00148/[8o\u001f\u001a47/\u001a;\u0002W\rc\u0017m]:NC:Lg-Z:u\u0007>l\u0007O]3tg&|g\u000eV1cY\u00164VM]:j_:|eMZ:fi\u0002\n\u0011\"V5e\u001f\u001a47/\u001a;\u0002\u0015UKGm\u00144gg\u0016$\b%\u0001\tTKJL\u0017\r\\5{KJ|eMZ:fi\u0006\t2+\u001a:jC2L'0\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002/M+g\u000eZ3s\u0003\u000e$xN\u001d*fMR\u000bwm\u00144gg\u0016$\u0018\u0001G*f]\u0012,'/Q2u_J\u0014VM\u001a+bO>3gm]3uA\u0005Q\"+Z2ja&,g\u000e^!di>\u0014(+\u001a4UC\u001e|eMZ:fi\u0006Y\"+Z2ja&,g\u000e^!di>\u0014(+\u001a4UC\u001e|eMZ:fi\u0002\nac\u00117bgNl\u0015M\\5gKN$H+Y4PM\u001a\u001cX\r^\u0001\u0018\u00072\f7o]'b]&4Wm\u001d;UC\u001e|eMZ:fi\u0002\n\u0001&T3uC\u0012\fG/Y\"p]R\f\u0017N\\3s\u0003:$G*\u001b;fe\u0006d7+Z2uS>twJ\u001a4tKR\f\u0011&T3uC\u0012\fG/Y\"p]R\f\u0017N\\3s\u0003:$G*\u001b;fe\u0006d7+Z2uS>twJ\u001a4tKR\u00043CA\u000fG\u0003)\u0011\u0017\u0010^3Ck\u001a4WM]\u000b\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0004]&|'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014!BQ=uK\n+hMZ3s\u0003-\u0011\u0017\u0010^3Ck\u001a4WM\u001d\u0011\u0015\u0005y|\bCA\"\u001e\u0011\u0015\u0011\b\u00051\u0001u\u0003-\tWM]8o\u0005V4g-\u001a:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u000bG>t7-\u001e:sK:$(bAA\b\u0001\u00061\u0011m\u001a:p]\u0006LA!a\u0005\u0002\n\taQK\\:bM\u0016\u0014UO\u001a4fe\u0006a\u0011-\u001a:p]\n+hMZ3sA\u0005aA.\u001b;fe\u0006d7\t[1sgV\u0011\u00111\u0004\t\u0006\u000f\u0006u\u0011\u0011E\u0005\u0004\u0003?A%!B!se\u0006L\bcA$\u0002$%\u0019\u0011Q\u0005%\u0003\t\rC\u0017M]\u0001\u0011Y&$XM]1m\u0007\"\f'o]0%KF$B!a\u000b\u00022A\u0019q)!\f\n\u0007\u0005=\u0002J\u0001\u0003V]&$\b\"CA\u001aI\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u000eY&$XM]1m\u0007\"\f'o\u001d\u0011\u0002\u00191LG/\u001a:bY\nKH/Z:\u0016\u0005\u0005m\u0002#B$\u0002\u001e\u0005u\u0002cA$\u0002@%\u0019\u0011\u0011\t%\u0003\t\tKH/Z\u0001\u0011Y&$XM]1m\u0005f$Xm]0%KF$B!a\u000b\u0002H!I\u00111G\u0014\u0002\u0002\u0003\u0007\u00111H\u0001\u000eY&$XM]1m\u0005f$Xm\u001d\u0011\u0002\u0013}\u001bHO]3b[&#\u0017!D0tiJ,\u0017-\\%e?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0003\u0002CA\u001aU\u0005\u0005\t\u0019A)\u0002\u0015}\u001bHO]3b[&#\u0007%\u0001\u0005tiJ,\u0017-\\%e\u0003-\u0019X\r^*ue\u0016\fW.\u00133\u0015\t\u0005-\u00121\f\u0005\u0007\u0003;j\u0003\u0019A)\u0002\u00179,wo\u0015;sK\u0006l\u0017\nZ\u0001\foJLG/\u001a%fC\u0012,'\u000f\u0006\u0003\u0002,\u0005\r\u0004bBA3]\u0001\u0007\u0011qM\u0001\u0002QB\u00191)!\u001b\n\u0007\u0005-\u0004HA\u0007IK\u0006$WM\u001d\"vS2$WM\u001d\u000b\u0007\u0003W\ty'!\u001d\t\u000f\u0005\u0015t\u00061\u0001\u0002h!9\u00111O\u0018A\u0002\u0005U\u0014AA8f!\r\u0019\u0015qO\u0005\u0004\u0003sB$\u0001E(vi\n|WO\u001c3F]Z,Gn\u001c9f\u0003-\u0001\u0018M]:f\u0011\u0016\fG-\u001a:\u0015\t\u0005-\u0012q\u0010\u0005\b\u0003K\u0002\u0004\u0019AA4\u0003-)W\u000e\u001d;z\u0003NtU\u000f\u001c7\u0015\t\u0005\u0015\u00151\u0014\t\u0005\u0003\u000f\u000b)J\u0004\u0003\u0002\n\u0006E\u0005cAAF\u00116\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fk\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0014\"\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAL\u00033\u0013aa\u0015;sS:<'bAAJ\u0011\"9\u0011QT\u0019A\u0002\u0005\u0015\u0015!A:\u0002\u0017I,\u0017\r\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0003\u0003\u000b\u000bAb\u001e:ji\u0016d\u0015\u000e^3sC2$b!a\u000b\u0002(\u0006-\u0006BBAUg\u0001\u0007\u0011+A\u0005uC\u001e|eMZ:fi\"9\u0011QV\u001aA\u0002\u0005\u0015\u0015a\u00027ji\u0016\u0014\u0018\r\\\u0001\u0019K:\u001cXO]3MSR,'/\u00197DQ\u0006\u00148\u000fT3oORDG\u0003BA\u0016\u0003gCa!!.5\u0001\u0004\t\u0016A\u00027f]\u001e$\b.\u0001\ruef\u001cE.Z1o\t&\u0014Xm\u0019;CsR,')\u001e4gKJ$\"!a\u000b\u0002\t\r|\u0007/\u001f\u000b\u0002}\u0002")
public final class EnvelopeBuffer {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer aeronBuffer;
    private char[] literalChars;
    private byte[] literalBytes;
    private int _streamId;

    public static int MetadataContainerAndLiteralSectionOffset() {
        return EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset();
    }

    public static int ClassManifestTagOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestTagOffset();
    }

    public static int RecipientActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset();
    }

    public static int SenderActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset();
    }

    public static int SerializerOffset() {
        return EnvelopeBuffer$.MODULE$.SerializerOffset();
    }

    public static int UidOffset() {
        return EnvelopeBuffer$.MODULE$.UidOffset();
    }

    public static int ClassManifestCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset();
    }

    public static int ActorRefCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset();
    }

    public static int FlagsOffset() {
        return EnvelopeBuffer$.MODULE$.FlagsOffset();
    }

    public static int VersionOffset() {
        return EnvelopeBuffer$.MODULE$.VersionOffset();
    }

    public static byte MetadataPresentFlag() {
        return EnvelopeBuffer$.MODULE$.MetadataPresentFlag();
    }

    public static int TagValueMask() {
        return EnvelopeBuffer$.MODULE$.TagValueMask();
    }

    public static int TagTypeMask() {
        return EnvelopeBuffer$.MODULE$.TagTypeMask();
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public UnsafeBuffer aeronBuffer() {
        return this.aeronBuffer;
    }

    private char[] literalChars() {
        return this.literalChars;
    }

    private void literalChars_$eq(char[] x$1) {
        this.literalChars = x$1;
    }

    private byte[] literalBytes() {
        return this.literalBytes;
    }

    private void literalBytes_$eq(byte[] x$1) {
        this.literalBytes = x$1;
    }

    private int _streamId() {
        return this._streamId;
    }

    private void _streamId_$eq(int x$1) {
        this._streamId = x$1;
    }

    public int streamId() {
        if (this._streamId() != -1) {
            return this._streamId();
        }
        throw new IllegalStateException("StreamId was not set");
    }

    public void setStreamId(int newStreamId) {
        this._streamId_$eq(newStreamId);
    }

    public void writeHeader(HeaderBuilder h) {
        this.writeHeader(h, null);
    }

    public void writeHeader(HeaderBuilder h, OutboundEnvelope oe) {
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        this.byteBuffer().clear();
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.VersionOffset(), header.version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset(), header.outboundActorRefCompression().version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset(), header.outboundClassManifestCompression().version());
        this.byteBuffer().putLong(EnvelopeBuffer$.MODULE$.UidOffset(), header.uid());
        this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SerializerOffset(), header.serializer());
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (OptionVal$.MODULE$.isDefined$extension(header._remoteInstruments())) {
            OptionVal$.MODULE$.get$extension(header._remoteInstruments()).serialize(OptionVal$.MODULE$.apply(oe), this.byteBuffer());
            if (this.byteBuffer().position() != EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset()) {
                header.setFlag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag());
                this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
            }
        }
        if (header._senderActorRefIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRef());
        }
        if (header._recipientActorRefIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRef());
        }
        if (header._manifestIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifestIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
            return;
        }
        this.writeLiteral(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifest());
    }

    public void parseHeader(HeaderBuilder h) {
        int senderTag;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        header.setVersion(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.VersionOffset()));
        if (header.version() > ArteryTransport$.MODULE$.HighestVersion()) {
            throw new IllegalArgumentException(new StringBuilder(75).append("Incompatible protocol version [").append(header.version()).append("], ").append("highest known version for this node is [").append(ArteryTransport$.MODULE$.HighestVersion()).append("]").toString());
        }
        header.setFlags(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.FlagsOffset()));
        header._inboundActorRefCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset()));
        header._inboundClassManifestCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset()));
        header.setUid(this.byteBuffer().getLong(EnvelopeBuffer$.MODULE$.UidOffset()));
        header.setSerializer(this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SerializerOffset()));
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (header.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            int totalMetadataLength = this.byteBuffer().getInt();
            this.byteBuffer().position(this.byteBuffer().position() + totalMetadataLength);
        }
        if (((senderTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset())) & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = senderTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._senderActorRef_$eq(null);
            header._senderActorRefIdx_$eq(idx);
        } else {
            header._senderActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int recipientTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset());
        if ((recipientTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = recipientTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._recipientActorRef_$eq(null);
            header._recipientActorRefIdx_$eq(idx);
        } else {
            header._recipientActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int manifestTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset());
        if ((manifestTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = manifestTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._manifest_$eq(null);
            header._manifestIdx_$eq(idx);
            return;
        }
        header._manifest_$eq(this.readLiteral());
    }

    private String emptyAsNull(String s) {
        String string = s;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return null;
        }
        return s;
    }

    private String readLiteral() {
        int length = this.byteBuffer().getShort();
        if (length == 0) {
            return "";
        }
        this.ensureLiteralCharsLength(length);
        char[] chars = this.literalChars();
        byte[] bytes = this.literalBytes();
        this.byteBuffer().get(bytes, 0, length);
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return String.valueOf(chars, 0, length);
    }

    private void writeLiteral(int tagOffset, String literal) {
        int length;
        int n = length = literal == null ? 0 : literal.length();
        if (length > 65535) {
            throw new IllegalArgumentException("Literals longer than 65535 cannot be encoded in the envelope");
        }
        this.byteBuffer().putInt(tagOffset, this.byteBuffer().position());
        this.byteBuffer().putShort((short)length);
        if (length > 0) {
            this.ensureLiteralCharsLength(length);
            byte[] bytes = this.literalBytes();
            Unsafe.copyUSAsciiStrToBytes(literal, bytes);
            this.byteBuffer().put(bytes, 0, length);
            return;
        }
    }

    private void ensureLiteralCharsLength(int length) {
        if (length > this.literalChars().length) {
            this.literalChars_$eq(new char[length]);
            this.literalBytes_$eq(new byte[length]);
            return;
        }
    }

    public void tryCleanDirectByteBuffer() {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(this.byteBuffer());
    }

    public EnvelopeBuffer copy() {
        int p = this.byteBuffer().position();
        this.byteBuffer().rewind();
        byte[] bytes = new byte[this.byteBuffer().remaining()];
        this.byteBuffer().get(bytes);
        ByteBuffer newByteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        newByteBuffer.position(p);
        this.byteBuffer().position(p);
        return new EnvelopeBuffer(newByteBuffer);
    }

    public EnvelopeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.aeronBuffer = new UnsafeBuffer(byteBuffer);
        this.literalChars = new char[64];
        this.literalBytes = new byte[64];
        this._streamId = -1;
    }
}

