/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.asn1;

import com.hierynomus.asn1.ASN1ParseException;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.ASN1Tag;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1InputStream
extends FilterInputStream
implements Iterable<ASN1Object> {
    private static final Logger logger = LoggerFactory.getLogger(ASN1InputStream.class);
    private final ASN1Decoder decoder;

    public ASN1InputStream(ASN1Decoder decoder, InputStream wrapped) {
        super(wrapped);
        this.decoder = decoder;
    }

    public ASN1InputStream(ASN1Decoder decoder, byte[] value) {
        super(new ByteArrayInputStream(value));
        this.decoder = decoder;
    }

    public <T extends ASN1Object> T readObject() {
        try {
            ASN1Tag<? extends ASN1Object> tag = this.decoder.readTag(this);
            logger.trace("Read ASN.1 tag {}", tag);
            int length = this.decoder.readLength(this);
            logger.trace("Read ASN.1 object length: {}", (Object)length);
            byte[] value = this.decoder.readValue(length, this);
            ASN1Object parse2 = tag.newParser(this.decoder).parse(tag, value);
            logger.debug("Read ASN.1 object: {}", (Object)parse2);
            return (T)parse2;
        }
        catch (ASN1ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ASN1ParseException(e, "Cannot parse ASN.1 object from stream", new Object[0]);
        }
    }

    public byte[] readValue(int length) {
        return this.decoder.readValue(length, this);
    }

    @Override
    public Iterator<ASN1Object> iterator() {
        return new Iterator<ASN1Object>(){

            @Override
            public boolean hasNext() {
                try {
                    return ASN1InputStream.this.available() > 0;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public ASN1Object next() {
                try {
                    return ASN1InputStream.this.readObject();
                }
                catch (Exception e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported on ASN.1 InputStream iterator");
            }
        };
    }

    public ASN1Tag readTag() {
        return this.decoder.readTag(this);
    }

    public int readLength() {
        return this.decoder.readLength(this);
    }
}

