/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.dispatch.Dispatchers;
import akka.dispatch.MessageDispatcher;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.remote.RARP;
import akka.remote.RARP$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.Transport;
import akka.remote.transport.netty.ClientHandler;
import akka.remote.transport.netty.NettyFutureBridge$;
import akka.remote.transport.netty.NettySSLSupport$;
import akka.remote.transport.netty.NettyTransport$;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.NettyTransportExceptionNoStack;
import akka.remote.transport.netty.NettyTransportSettings;
import akka.remote.transport.netty.SSLEngineProvider;
import akka.remote.transport.netty.TcpClientHandler;
import akka.remote.transport.netty.TcpServerHandler;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001drA\u0002\u001e<\u0011\u0003i4I\u0002\u0004Fw!\u0005QH\u0012\u0005\u0006\u001b\u0006!\ta\u0014\u0005\b!\u0006\u0011\r\u0011\"\u0001R\u0011\u0019)\u0016\u0001)A\u0005%\")a+\u0001C\u0001/\"9\u0001/\u0001b\u0001\n\u0003\t\bBB?\u0002A\u0003%!\u000fC\u0003\u007f\u0003\u0011\u0005q\u0010\u0003\u0004\u007f\u0003\u0011\u0005\u0011Q\n\u0004\u0006\u000bn\u0002\u0011q\r\u0005\u000b\u0003cR!Q1A\u0005\u0002\u0005M\u0004BCA>\u0015\t\u0005\t\u0015!\u0003\u0002v!Q\u0011Q\u0010\u0006\u0003\u0006\u0004%\t!a \t\u0015\u0005\u001d%B!A!\u0002\u0013\t\t\t\u0003\u0004N\u0015\u0011\u0005\u0011\u0011\u0012\u0005\u0007\u001b*!\t!!%\t\u0013\u00055&B1A\u0005\u0004\u0005=\u0006bBAY\u0015\u0001\u0006IA\u0018\u0005\n\u0003KQ!\u0019!C!\u0003gC\u0001\"!.\u000bA\u0003%\u0011q\u0005\u0005\u0007\u0003oSA\u0011I)\t\u0017\u0005e&\u00021AA\u0002\u0013%\u00111\u0018\u0005\f\u0003{S\u0001\u0019!a\u0001\n\u0013\ty\fC\u0006\u0002F*\u0001\r\u0011!Q!\n\u0005\u001d\u0001bCAh\u0015\u0001\u0007\t\u0019!C\u0005\u0003#D1\"a5\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u0002V\"Q\u0011\u0011\u001c\u0006A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013\u0005u'B1A\u0005\n\u0005}\u0007\u0002CAw\u0015\u0001\u0006I!!9\t\u0015\u0005=(B1A\u0005\u0006m\n\t\u0010\u0003\u0005\u0003\u0016)\u0001\u000bQBAz\u0011\u001d\u00119B\u0003C\u0005\u00053A\u0011B!\t\u000b\u0005\u0004%\tAa\t\t\u0011\tE\"\u0002)A\u0005\u0005KA\u0011Ba\r\u000b\u0005\u0004%IA!\u000e\t\u0011\tu\"\u0002)A\u0005\u0005oA\u0011Ba\u0010\u000b\u0005\u0004%IA!\u000e\t\u0011\t\u0005#\u0002)A\u0005\u0005oAqAa\u0011\u000b\t\u0013\u0011)\u0005C\u0005\u0003N)\u0011\r\u0011\"\u0003\u0003P!A!Q\r\u0006!\u0002\u0013\u0011\t\u0006C\u0005\u0003h)\u0011\r\u0011\"\u0003\u0003j!A!1\u0010\u0006!\u0002\u0013\u0011Y\u0007C\u0004\u0003~)!IAa \t\u0013\tm%B1A\u0005\n\tu\u0005\u0002\u0003BS\u0015\u0001\u0006IAa(\t\u000f\t\u001d&\u0002\"\u0003\u0003*\"9!q\u0016\u0006\u0005\n\tE\u0006\"\u0003Bl\u0015\t\u0007I\u0011\u0002Bm\u0011!\u0011YN\u0003Q\u0001\n\t\u0015\u0007b\u0002Bo\u0015\u0011%!q\u001c\u0005\b\u0005STA\u0011\tBv\u0011\u001d\u0011\tP\u0003C\u0001\u0005gDqaa\u0001\u000b\t\u0003\u001a)\u0001\u0003\u0005\u0004\u0010)!\t!QA^\u0011\u001d\u0019\tB\u0003C!\u0007'Aqaa\b\u000b\t\u0003\u001a\t#\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u000b\u0005qj\u0014!\u00028fiRL(B\u0001 @\u0003%!(/\u00198ta>\u0014HO\u0003\u0002A\u0003\u00061!/Z7pi\u0016T\u0011AQ\u0001\u0005C.\\\u0017\r\u0005\u0002E\u00035\t1H\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\u0014\u0005\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0015A\u0006$sC6,G*\u001a8hi\"4\u0015.\u001a7e\u0019\u0016tw\r\u001e5\u0016\u0003I\u0003\"\u0001S*\n\u0005QK%aA%oi\u00069bI]1nK2+gn\u001a;i\r&,G\u000e\u001a'f]\u001e$\b\u000eI\u0001\u000eOJ\f7-\u001a4vY\u000ecwn]3\u0015\u0005a#GCA-]!\tA%,\u0003\u0002\\\u0013\n!QK\\5u\u0011\u0015iV\u0001q\u0001_\u0003\t)7\r\u0005\u0002`E6\t\u0001M\u0003\u0002b\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0004'\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015)W\u00011\u0001g\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"a\u001a8\u000e\u0003!T!!Z5\u000b\u0005qR'BA6m\u0003\u0015Q'm\\:t\u0015\u0005i\u0017aA8sO&\u0011q\u000e\u001b\u0002\b\u0007\"\fgN\\3m\u0003=)h.[9vK&#7i\\;oi\u0016\u0014X#\u0001:\u0011\u0005M\\X\"\u0001;\u000b\u0005U4\u0018AB1u_6L7M\u0003\u0002bo*\u0011\u00010_\u0001\u0005kRLGNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q$(!D!u_6L7-\u00138uK\u001e,'/\u0001\tv]&\fX/Z%e\u0007>,h\u000e^3sA\u0005A\u0012\r\u001a3sKN\u001chI]8n'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0015\u0019\u0005\u0005\u00111CA\u0012\u0003{\t\t%a\u0012\u0011\u000b!\u000b\u0019!a\u0002\n\u0007\u0005\u0015\u0011J\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB!\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005E\u00111\u0002\u0002\b\u0003\u0012$'/Z:t\u0011\u001d\t)\u0002\u0003a\u0001\u0003/\tA!\u00193eeB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001ee\f1A\\3u\u0013\u0011\t\t#a\u0007\u0003\u001bM{7m[3u\u0003\u0012$'/Z:t\u0011\u001d\t)\u0003\u0003a\u0001\u0003O\t\u0001c]2iK6,\u0017\nZ3oi&4\u0017.\u001a:\u0011\t\u0005%\u0012q\u0007\b\u0005\u0003W\t\u0019\u0004E\u0002\u0002.%k!!a\f\u000b\u0007\u0005Eb*\u0001\u0004=e>|GOP\u0005\u0004\u0003kI\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002:\u0005m\"AB*ue&twMC\u0002\u00026%Cq!a\u0010\t\u0001\u0004\t9#\u0001\u0006tsN$X-\u001c(b[\u0016Dq!a\u0011\t\u0001\u0004\t)%\u0001\u0005i_N$h*Y7f!\u0015A\u00151AA\u0014\u0011\u001d\tI\u0005\u0003a\u0001\u0003\u0017\nA\u0001]8siB!\u0001*a\u0001S))\t\t!a\u0014\u0002R\u0005M\u0013Q\u000b\u0005\b\u0003+I\u0001\u0019AA\f\u0011\u001d\t)#\u0003a\u0001\u0003OAq!a\u0010\n\u0001\u0004\t9\u0003C\u0004\u0002D%\u0001\r!!\u0012)\u000f\u0005\tI&a\u0018\u0002dA\u0019\u0001*a\u0017\n\u0007\u0005u\u0013J\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!\u0019\u0002U\rc\u0017m]:jG\u0002\u0012X-\\8uS:<\u0007%[:!I\u0016\u0004(/Z2bi\u0016$G\u0006I;tK\u0002\n%\u000f^3ss\u0006\u0012\u0011QM\u0001\u0006e92d\u0006M\n\u0005\u0015\u001d\u000bI\u0007\u0005\u0003\u0002l\u00055T\"A\u001f\n\u0007\u0005=THA\u0005Ue\u0006t7\u000f]8si\u0006A1/\u001a;uS:<7/\u0006\u0002\u0002vA\u0019A)a\u001e\n\u0007\u0005e4H\u0001\fOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\u0004tsN$X-\\\u000b\u0003\u0003\u0003\u0003B!!\u0003\u0002\u0004&!\u0011QQA\u0006\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\"b!a#\u0002\u000e\u0006=\u0005C\u0001#\u000b\u0011\u001d\t\th\u0004a\u0001\u0003kBq!! \u0010\u0001\u0004\t\t\t\u0006\u0004\u0002\f\u0006M\u0015Q\u0013\u0005\b\u0003{\u0002\u0002\u0019AAA\u0011\u001d\t9\n\u0005a\u0001\u00033\u000bAaY8oMB!\u00111TAU\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016AB2p]\u001aLwM\u0003\u0003\u0002$\u0006\u0015\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005\u001d\u0016aA2p[&!\u00111VAO\u0005\u0019\u0019uN\u001c4jO\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002=\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\u0016\u0005\u0005\u001d\u0012!E:dQ\u0016lW-\u00133f]RLg-[3sA\u0005\u0019R.\u0019=j[Vl\u0007+Y=m_\u0006$')\u001f;fg\u00069!m\\;oIR{WCAA\u0004\u0003-\u0011w.\u001e8e)>|F%Z9\u0015\u0007e\u000b\t\rC\u0005\u0002D^\t\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\t|WO\u001c3U_\u0002B3\u0001GAe!\rA\u00151Z\u0005\u0004\u0003\u001bL%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001bM,'O^3s\u0007\"\fgN\\3m+\u00051\u0017!E:feZ,'o\u00115b]:,Gn\u0018\u0013fcR\u0019\u0011,a6\t\u0011\u0005\r'$!AA\u0002\u0019\fab]3sm\u0016\u00148\t[1o]\u0016d\u0007\u0005K\u0002\u001c\u0003\u0013\f1\u0001\\8h+\t\t\t\u000f\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9/Q\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003W\f)O\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\nvIB\u001cuN\u001c8fGRLwN\u001c+bE2,WCAAz!!\t)0a>\u0002\u0018\u0005mX\"\u0001<\n\u0007\u0005ehOA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!@\u0003\u00109!\u0011q B\u0006\u001d\u0011\u0011\tA!\u0003\u000f\t\t\r!q\u0001\b\u0005\u0003[\u0011)!C\u0001C\u0013\t\u0001\u0015)\u0003\u0002?\u007f%\u0019!QB\u001f\u0002#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW-\u0003\u0003\u0003\u0012\tM!a\u0005%b]\u0012dW-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(b\u0001B\u0007{\u0005\u0019R\u000f\u001a9D_:tWm\u0019;j_:$\u0016M\u00197fA\u0005)2M]3bi\u0016,\u00050Z2vi>\u00148+\u001a:wS\u000e,GC\u0001B\u000e!\u0011\t)P!\b\n\u0007\t}aO\u0001\u0005Fq\u0016\u001cW\u000f^8s\u00031\u0019\u0007.\u00198oK2<%o\\;q+\t\u0011)\u0003\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\r\u0011Y\u0003[\u0001\u0006OJ|W\u000f]\u0005\u0005\u0005_\u0011ICA\nEK\u001a\fW\u000f\u001c;DQ\u0006tg.\u001a7He>,\b/A\u0007dQ\u0006tg.\u001a7He>,\b\u000fI\u0001\u0015G2LWM\u001c;DQ\u0006tg.\u001a7GC\u000e$xN]=\u0016\u0005\t]\u0002cA4\u0003:%\u0019!1\b5\u0003\u001d\rC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0006)2\r\\5f]R\u001c\u0005.\u00198oK24\u0015m\u0019;pef\u0004\u0013\u0001F:feZ,'o\u00115b]:,GNR1di>\u0014\u00180A\u000btKJ4XM]\"iC:tW\r\u001c$bGR|'/\u001f\u0011\u0002\u00179,w\u000fU5qK2Lg.Z\u000b\u0003\u0005\u000f\u00022a\u001aB%\u0013\r\u0011Y\u0005\u001b\u0002\u0017\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u0006Q\u0012m]:pG&\fG/[8o\u0019&\u001cH/\u001a8feB\u0013x.\\5tKV\u0011!\u0011\u000b\t\u0006?\nM#qK\u0005\u0004\u0005+\u0002'a\u0002)s_6L7/\u001a\t\u0005\u00053\u0012yF\u0004\u0003\u0002\u0000\nm\u0013b\u0001B/{\u0005IAK]1ogB|'\u000f^\u0005\u0005\u0005C\u0012\u0019G\u0001\rBgN|7-[1uS>tWI^3oi2K7\u000f^3oKJT1A!\u0018>\u0003m\t7o]8dS\u0006$\u0018n\u001c8MSN$XM\\3s!J|W.[:fA\u0005\t2o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:\u0016\u0005\t-\u0004C\u0002B7\u0005c\u0012)(\u0004\u0002\u0003p)\u0011\u00010Q\u0005\u0005\u0005g\u0012yGA\u0005PaRLwN\u001c,bYB\u0019AIa\u001e\n\u0007\te4HA\tT'2+enZ5oKB\u0013xN^5eKJ\f!c]:m\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3sA\u0005Q1o\u001d7IC:$G.\u001a:\u0015\t\t\u0005%\u0011\u0013\t\u0005\u0005\u0007\u0013i)\u0004\u0002\u0003\u0006*!!q\u0011BE\u0003\r\u00198\u000f\u001c\u0006\u0004\u0005\u0017K\u0017a\u00025b]\u0012dWM]\u0005\u0005\u0005\u001f\u0013)I\u0001\u0006Tg2D\u0015M\u001c3mKJDqAa%-\u0001\u0004\u0011)*\u0001\u0005jg\u000ec\u0017.\u001a8u!\rA%qS\u0005\u0004\u00053K%a\u0002\"p_2,\u0017M\\\u0001\u0016g\u0016\u0014h/\u001a:QSB,G.\u001b8f\r\u0006\u001cGo\u001c:z+\t\u0011y\nE\u0002h\u0005CK1Aa)i\u0005Y\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL\u0018AF:feZ,'\u000fU5qK2Lg.\u001a$bGR|'/\u001f\u0011\u0002+\rd\u0017.\u001a8u!&\u0004X\r\\5oK\u001a\u000b7\r^8ssR!!q\u0014BV\u0011\u001d\u0011ik\fa\u0001\u0003\u000f\tQB]3n_R,\u0017\t\u001a3sKN\u001c\u0018AD:fiV\u0004(i\\8ugR\u0014\u0018\r]\u000b\u0005\u0005g\u0013I\f\u0006\u0004\u00036\nE'1\u001b\t\u0005\u0005o\u0013I\f\u0004\u0001\u0005\u000f\tm\u0006G1\u0001\u0003>\n\t!)\u0005\u0003\u0003@\n\u0015\u0007c\u0001%\u0003B&\u0019!1Y%\u0003\u000f9{G\u000f[5oOB!!q\u0019Bg\u001b\t\u0011IMC\u0002\u0003L&\f\u0011BY8piN$(/\u00199\n\t\t='\u0011\u001a\u0002\n\u0005>|Go\u001d;sCBDqAa31\u0001\u0004\u0011)\fC\u0004\u0003VB\u0002\rAa(\u0002\u001fAL\u0007/\u001a7j]\u00164\u0015m\u0019;pef\f\u0001#\u001b8c_VtGMQ8piN$(/\u00199\u0016\u0005\t\u0015\u0017!E5oE>,h\u000e\u001a\"p_R\u001cHO]1qA\u0005\tr.\u001e;c_VtGMQ8piN$(/\u00199\u0015\t\t\u0005(q\u001d\t\u0005\u0005\u000f\u0014\u0019/\u0003\u0003\u0003f\n%'aD\"mS\u0016tGOQ8piN$(/\u00199\t\u000f\t56\u00071\u0001\u0002\b\u0005\u0001\u0012n\u001d*fgB|gn]5cY\u00164uN\u001d\u000b\u0005\u0005+\u0013i\u000fC\u0004\u0003pR\u0002\r!a\u0002\u0002\u000f\u0005$GM]3tg\u00061\u0012\r\u001a3sKN\u001cHk\\*pG.,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003v\u000e\u0005\u0001#B0\u0003x\nm\u0018b\u0001B}A\n1a)\u001e;ve\u0016\u0004B!!\u0007\u0003~&!!q`A\u000e\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u0003+)\u0004\u0019AA\u0004\u0003\u0019a\u0017n\u001d;f]V\u00111q\u0001\t\u0006?\n]8\u0011\u0002\t\b\u0011\u000e-\u0011q\u0001B)\u0013\r\u0019i!\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0019\t|WO\u001c3BI\u0012\u0014Xm]:\u0002\u0013\u0005\u001c8o\\2jCR,G\u0003BB\u000b\u0007;\u0001Ra\u0018B|\u0007/\u0001B!a\u001b\u0004\u001a%\u001911D\u001f\u0003#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW\rC\u0004\u0003.b\u0002\r!a\u0002\u0002\u0011MDW\u000f\u001e3po:$\"aa\t\u0011\u000b}\u00139P!&)\u000f)\tI&a\u0018\u0002d\u0001")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log;
    private final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable;
    private final DefaultChannelGroup channelGroup;
    private final ChannelFactory clientChannelFactory;
    private final ChannelFactory serverChannelFactory;
    private final Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelPipelineFactory serverPipelineFactory;
    private final Bootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    public MarkerLoggingAdapter akka$remote$transport$netty$NettyTransport$$log() {
        return this.akka$remote$transport$netty$NettyTransport$$log;
    }

    public final ConcurrentHashMap<SocketAddress, AssociationHandle.HandleEventListener> udpConnectionTable() {
        return this.udpConnectionTable;
    }

    private Executor createExecutorService() {
        Dispatchers dispatchers = this.system().dispatchers();
        return (Executor)this.settings().UseDispatcherForIo().map((Function1<String, MessageDispatcher> & Serializable & scala.Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0<ExecutorService> & Serializable & scala.Serializable)() -> Executors.newCachedThreadPool(this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private ChannelFactory clientChannelFactory() {
        return this.clientChannelFactory;
    }

    private ChannelFactory serverChannelFactory() {
        return this.serverChannelFactory;
    }

    public DefaultChannelPipeline akka$remote$transport$netty$NettyTransport$$newPipeline() {
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        pipeline.addLast("FrameDecoder", new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    public Promise<Transport.AssociationEventListener> akka$remote$transport$netty$NettyTransport$$associationListenerPromise() {
        return this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    public SslHandler akka$remote$transport$netty$NettyTransport$$sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = OptionVal$Some$.MODULE$.unapply(sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension(sSLEngineProvider2)) {
            SSLEngineProvider sslProvider = OptionVal$.MODULE$.get$extension(sSLEngineProvider2);
            SslHandler handler = NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
            handler.setCloseOnSSLException(true);
            return handler;
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelPipelineFactory serverPipelineFactory() {
        return this.serverPipelineFactory;
    }

    private ChannelPipelineFactory clientPipelineFactory(Address remoteAddress) {
        return new ChannelPipelineFactory(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(true));
                }
                TcpClientHandler handler = new TcpClientHandler(this.$outer, this.remoteAddress$1, this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("clienthandler", handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private <B extends Bootstrap> B setupBootstrap(B bootstrap, ChannelPipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("backlog", BoxesRunTime.boxToInteger(this.settings().Backlog()));
        bootstrap.setOption("child.tcpNoDelay", BoxesRunTime.boxToBoolean(this.settings().TcpNodelay()));
        bootstrap.setOption("child.keepAlive", BoxesRunTime.boxToBoolean(this.settings().TcpKeepalive()));
        bootstrap.setOption("reuseAddress", BoxesRunTime.boxToBoolean(this.settings().TcpReuseAddr()));
        this.settings().ReceiveBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().SendBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferHighWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferLowWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger(sz)));
        return bootstrap;
    }

    private Bootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private ClientBootstrap outboundBootstrap(Address remoteAddress) {
        ClientBootstrap bootstrap = this.setupBootstrap(new ClientBootstrap(this.clientChannelFactory()), this.clientPipelineFactory(remoteAddress));
        bootstrap.setOption("connectTimeoutMillis", BoxesRunTime.boxToLong(this.settings().ConnectionTimeout().toMillis()));
        bootstrap.setOption("tcpNoDelay", BoxesRunTime.boxToBoolean(this.settings().TcpNodelay()));
        bootstrap.setOption("keepAlive", BoxesRunTime.boxToBoolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("receiveBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().SendBufferSize().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("sendBufferSize", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferHighWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferHighWaterMark", BoxesRunTime.boxToInteger(sz)));
        this.settings().WriteBufferLowWaterMark().foreach((JFunction1$mcVI$sp & scala.Serializable)sz -> bootstrap.setOption("writeBufferLowWaterMark", BoxesRunTime.boxToInteger(sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        Address address = addr;
        if (address != null) {
            Option<String> option = address.host();
            Option<Object> option2 = address.port();
            if (option instanceof Some) {
                Some some = (Some)option;
                String host = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt(some2.value());
                    return Future$.MODULE$.apply((Function0<InetSocketAddress> & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0<InetSocketAddress> & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed(new IllegalArgumentException(new StringBuilder(53).append("Address [").append(addr).append("] does not contain host or port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return this.addressToSocketAddress(Address$.MODULE$.apply("", "", this.settings().BindHostname(), bindPort)).map((Function1<InetSocketAddress, Tuple2> & Serializable & scala.Serializable)address -> {
            Tuple2<Address, Promise<Transport.AssociationEventListener>> tuple2;
            try {
                Address address2;
                Channel channel;
                Bootstrap bootstrap = this.inboundBootstrap();
                if (bootstrap instanceof ServerBootstrap) {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)bootstrap;
                    channel = serverBootstrap.bind((SocketAddress)address);
                } else if (bootstrap instanceof ConnectionlessBootstrap) {
                    ConnectionlessBootstrap connectionlessBootstrap = (ConnectionlessBootstrap)bootstrap;
                    channel = connectionlessBootstrap.bind((SocketAddress)address);
                } else {
                    throw new IllegalStateException();
                }
                Channel newServerChannel = channel;
                newServerChannel.setReadable(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                Option port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), new Some<String>(this.settings().Hostname()), port);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    address2 = (Address)some.value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.getLocalAddress(), this.schemeIdentifier(), this.system().name(), None$.MODULE$, None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Some some2 = (Some)option2;
                    Address address3 = (Address)some2.value();
                    this.boundTo_$eq(address3);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.getLocalAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future().foreach((Function1<Transport.AssociationEventListener, ChannelFuture> & Serializable & scala.Serializable)x$2 -> newServerChannel.setReadable(true), this.executionContext());
                tuple2 = new Tuple2<Address, Promise<Transport.AssociationEventListener>>(address2, this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e;
                    block15: {
                        Object object;
                        e = option.get();
                        this.akka$remote$transport$netty$NettyTransport$$log().error("failed to bind to {}, shutting down Netty transport", address);
                        try {
                            object = this.shutdown();
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            Option<Throwable> option3 = NonFatal$.MODULE$.unapply(throwable4);
                            if (!option3.isEmpty()) {
                                object = BoxedUnit.UNIT;
                                break block15;
                            }
                            throw throwable3;
                        }
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }, this.executionContext());
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isBound()) {
            return Future$.MODULE$.failed(new NettyTransportException("Transport is not bound"));
        }
        ClientBootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return this.addressToSocketAddress(remoteAddress).flatMap((Function1<InetSocketAddress, Future> & Serializable & scala.Serializable)socketAddress -> NettyFutureBridge$.MODULE$.apply(bootstrap.connect((SocketAddress)socketAddress)).map((Function1<Channel, Channel> & Serializable & scala.Serializable)channel -> {
            BoxedUnit boxedUnit = this.settings().EnableSsl() ? package$.MODULE$.blocking((Function0<ChannelFuture> & Serializable & scala.Serializable)() -> channel.getPipeline().get(SslHandler.class).handshake().awaitUninterruptibly()) : BoxedUnit.UNIT;
            channel.setReadable(false);
            return channel;
        }, this.executionContext()).flatMap((Function1<Channel, Future> & Serializable & scala.Serializable)readyChannel -> readyChannel.getPipeline().get(ClientHandler.class).statusFuture().map((Function1<AssociationHandle, AssociationHandle> & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext()).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable t = option.get();
                    String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CancellationException) {
                    return true;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().unbind()).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean(unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$3) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1<ChannelGroup, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(NettyTransport.$anonfun$shutdown$1(x$3)), this.executionContext()).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)BoxesRunTime.boxToBoolean(false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        if ($this.settings().UseDispatcherForIo().isDefined()) {
            $this.clientChannelFactory().shutdown();
            $this.serverChannelFactory().shutdown();
        } else {
            $this.clientChannelFactory().releaseExternalResources();
            $this.serverChannelFactory().releaseExternalResources();
        }
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1<Object, Object> & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean(NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean(closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean(disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().write(ChannelBuffers.buffer(0))).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean(lastWriteStatus)), $this.executionContext());
    }

    public NettyTransport(NettyTransportSettings settings2, ExtendedActorSystem system) {
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings2;
        this.system = system;
        Transport.$init$(this);
        Dispatchers dispatchers = system.dispatchers();
        this.executionContext = (ExecutionContext)settings2.UseDispatcherForIo().orElse((Function0<Option> & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply(this.system())).provider().remoteSettings().Dispatcher();
            if ("".equals(string)) {
                return None$.MODULE$;
            }
            return new Some<String>(string);
        }).map((Function1<String, MessageDispatcher> & Serializable & scala.Serializable)id -> dispatchers.lookup((String)id)).getOrElse((Function0<ExecutionContextExecutor> & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings2.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.akka$remote$transport$netty$NettyTransport$$log = Logging$.MODULE$.withMarker(system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.udpConnectionTable = new ConcurrentHashMap();
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(41).append("akka-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString());
        Executor boss = this.createExecutorService();
        Executor worker = this.createExecutorService();
        this.clientChannelFactory = new NioClientSocketChannelFactory(boss, 1, new NioWorkerPool(worker, settings2.ClientSocketWorkerPoolSize()), new HashedWheelTimer(system.threadFactory()));
        Executor boss2 = this.createExecutorService();
        Executor worker2 = this.createExecutorService();
        this.serverChannelFactory = new NioServerSocketChannelFactory(boss2, worker2, settings2.ServerSocketWorkerPoolSize());
        this.akka$remote$transport$netty$NettyTransport$$associationListenerPromise = Promise$.MODULE$.apply();
        if (settings2.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)((Object)OptionVal$Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings2.SSLEngineProviderClassName(), new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<Class<ActorSystem>, ExtendedActorSystem>(ActorSystem.class, system)), Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), A1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get()));
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineFactory = new ChannelPipelineFactory(this){
            private final /* synthetic */ NettyTransport $outer;

            public ChannelPipeline getPipeline() {
                DefaultChannelPipeline pipeline = this.$outer.akka$remote$transport$netty$NettyTransport$$newPipeline();
                if (this.$outer.settings().EnableSsl()) {
                    pipeline.addFirst("SslHandler", this.$outer.akka$remote$transport$netty$NettyTransport$$sslHandler(false));
                }
                TcpServerHandler handler = new TcpServerHandler(this.$outer, this.$outer.akka$remote$transport$netty$NettyTransport$$associationListenerPromise().future(), this.$outer.akka$remote$transport$netty$NettyTransport$$log());
                pipeline.addLast("ServerHandler", handler);
                return pipeline;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.inboundBootstrap = this.setupBootstrap(new ServerBootstrap(this.serverChannelFactory()), this.serverPipelineFactory());
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

