/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.event.LoggingAdapter;
import akka.protobufv3.internal.ByteString;
import akka.remote.ByteStringUtils$;
import akka.remote.ContainerFormats;
import akka.remote.serialization.ThrowableNotSerializableException;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.serialization.Serializers$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class WrappedPayloadSupport$ {
    public static WrappedPayloadSupport$ MODULE$;

    static {
        new WrappedPayloadSupport$();
    }

    public ContainerFormats.Payload.Builder payloadBuilder(Object input, Serialization serialization, LoggingAdapter log) {
        ContainerFormats.Payload.Builder builder;
        block1: {
            Serializer serializer;
            Object payload;
            block0: {
                payload = input;
                builder = ContainerFormats.Payload.newBuilder();
                serializer = serialization.findSerializerFor(payload);
                Object object = payload;
                if (!(object instanceof Throwable)) break block0;
                Throwable throwable = (Throwable)object;
                if (!(serializer instanceof DisabledJavaSerializer)) break block0;
                ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(throwable.getMessage(), throwable.getClass().getName(), throwable.getCause());
                log.debug("Couldn't serialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", notSerializableException.originalClassName(), notSerializableException.originalMessage());
                Serializer serializer2 = serialization.findSerializerFor(notSerializableException);
                builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer2.toBinary(notSerializableException))).setSerializerId(serializer2.identifier());
                String manifest = Serializers$.MODULE$.manifestFor(serializer2, notSerializableException);
                if (!new StringOps(Predef$.MODULE$.augmentString(manifest)).nonEmpty()) break block1;
                builder.setMessageManifest(ByteString.copyFromUtf8(manifest));
                break block1;
            }
            builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(payload))).setSerializerId(serializer.identifier());
            String manifest = Serializers$.MODULE$.manifestFor(serializer, payload);
            if (!new StringOps(Predef$.MODULE$.augmentString(manifest)).nonEmpty()) break block1;
            builder.setMessageManifest(ByteString.copyFromUtf8(manifest));
        }
        return builder;
    }

    public Object deserializePayload(ContainerFormats.Payload payload, Serialization serialization) {
        String manifest = payload.hasMessageManifest() ? payload.getMessageManifest().toStringUtf8() : "";
        Serializer serializer = (Serializer)serialization.serializerByIdentity().apply(BoxesRunTime.boxToInteger(payload.getSerializerId()));
        if (serializer instanceof ByteBufferSerializer) {
            Serializer serializer2 = serializer;
            ByteBuffer buffer = payload.getEnclosedMessage().asReadOnlyByteBuffer();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return ((ByteBufferSerializer)((Object)serializer2)).fromBinary(buffer, manifest);
        }
        if (serializer instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            return serializerWithStringManifest.fromBinary(payload.getEnclosedMessage().toByteArray(), manifest);
        }
        return serialization.deserialize(payload.getEnclosedMessage().toByteArray(), payload.getSerializerId(), manifest).get();
    }

    private WrappedPayloadSupport$() {
        MODULE$ = this;
    }
}

