/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.actor.ActorSelectionMessage;
import akka.actor.ExtendedActorSystem;
import akka.actor.SelectChildName;
import akka.actor.SelectChildPattern;
import akka.actor.SelectParent$;
import akka.actor.SelectionPathElement;
import akka.annotation.InternalApi;
import akka.protobufv3.internal.ByteString;
import akka.remote.ByteStringUtils$;
import akka.remote.ContainerFormats;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.ccompat.package$;
import akka.util.ccompat.package$JavaConverters$;
import java.io.NotSerializableException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4AAC\u0006\u0001%!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003!\u0011\u00159\u0003\u0001\"\u0001)\u0011!a\u0001\u0001#b\u0001\n\u0013a\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"B\u001b\u0001\t\u00031\u0004\"B \u0001\t\u0013\u0001\u0005\"\u0002$\u0001\t\u00139\u0005\"B5\u0001\t\u0003Q'AG'fgN\fw-Z\"p]R\f\u0017N\\3s'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0007\u000e\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011abD\u0001\u0007e\u0016lw\u000e^3\u000b\u0003A\tA!Y6lC\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"A\u0007\u000f\u000e\u0003mQ!\u0001D\b\n\u0005uY\"A\u0004\"bg\u0016\u001cVM]5bY&TXM]\u0001\u0007gf\u001cH/Z7\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR!aI\b\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\u0015\u0012#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u0005Y\u0001\"\u0002\u0010\u0004\u0001\u0004\u0001S#A\u0017\u0011\u0005iq\u0013BA\u0018\u001c\u00055\u0019VM]5bY&T\u0018\r^5p]\u0006y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u00013!\t!2'\u0003\u00025+\t9!i\\8mK\u0006t\u0017\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0005]j\u0004c\u0001\u000b9u%\u0011\u0011(\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003)mJ!\u0001P\u000b\u0003\t\tKH/\u001a\u0005\u0006}\u0019\u0001\raE\u0001\u0004_\nT\u0017AE:fe&\fG.\u001b>f'\u0016dWm\u0019;j_:$\"aN!\t\u000b\t;\u0001\u0019A\"\u0002\u0007M,G\u000e\u0005\u0002\"\t&\u0011QI\t\u0002\u0016\u0003\u000e$xN]*fY\u0016\u001cG/[8o\u001b\u0016\u001c8/Y4f\u00031\u0011W/\u001b7e!\u0006$H/\u001a:o)\rAE\u000b\u001a\t\u0003\u0013Fs!A\u0013(\u000f\u0005-cU\"A\u0007\n\u00055k\u0011\u0001E\"p]R\f\u0017N\\3s\r>\u0014X.\u0019;t\u0013\ty\u0005+A\u0005TK2,7\r^5p]*\u0011Q*D\u0005\u0003%N\u0013qAQ;jY\u0012,'O\u0003\u0002P!\")Q\u000b\u0003a\u0001-\u00069Q.\u0019;dQ\u0016\u0014\bc\u0001\u000bX3&\u0011\u0001,\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005i\u000bgBA.`!\taV#D\u0001^\u0015\tq\u0016#\u0001\u0004=e>|GOP\u0005\u0003AV\ta\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001-\u0006\u0005\u0006K\"\u0001\rAZ\u0001\u0004iB,\u0007C\u0001&h\u0013\tA\u0007KA\u0006QCR$XM\u001d8UsB,\u0017A\u00034s_6\u0014\u0015N\\1ssR\u00191c[7\t\u000b1L\u0001\u0019A\u001c\u0002\u000b\tLH/Z:\t\u000b9L\u0001\u0019A8\u0002\u00115\fg.\u001b4fgR\u00042\u0001F,qa\t\th\u000fE\u0002[eRL!a]2\u0003\u000b\rc\u0017m]:\u0011\u0005U4H\u0002\u0001\u0003\no6\f\t\u0011!A\u0003\u0002a\u00141a\u0018\u00132#\tIH\u0010\u0005\u0002\u0015u&\u001110\u0006\u0002\b\u001d>$\b.\u001b8h!\t!R0\u0003\u0002\u007f+\t\u0019\u0011I\\=")
public class MessageContainerSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final int identifier;
    private volatile boolean bitmap$0;

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        MessageContainerSerializer messageContainerSerializer = this;
        synchronized (messageContainerSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
            return this.serializeSelection(actorSelectionMessage);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Cannot serialize object of type [").append(obj.getClass().getName()).append("]").toString());
    }

    private byte[] serializeSelection(ActorSelectionMessage sel) {
        ContainerFormats.SelectionEnvelope.Builder builder = ContainerFormats.SelectionEnvelope.newBuilder();
        Object message = sel.msg();
        Serializer serializer = this.serialization().findSerializerFor(message);
        builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(message))).setSerializerId(serializer.identifier()).setWildcardFanOut(sel.wildcardFanOut());
        String ms = Serializers$.MODULE$.manifestFor(serializer, message);
        Object object = new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty() ? builder.setMessageManifest(ByteString.copyFromUtf8(ms)) : BoxedUnit.UNIT;
        sel.elements().foreach((Function1<SelectionPathElement, ContainerFormats.SelectionEnvelope.Builder> & Serializable & scala.Serializable)x0$1 -> {
            SelectionPathElement selectionPathElement = x0$1;
            if (selectionPathElement instanceof SelectChildName) {
                SelectChildName selectChildName = (SelectChildName)selectionPathElement;
                String name = selectChildName.name();
                return builder.addPattern(this.buildPattern(new Some<String>(name), ContainerFormats.PatternType.CHILD_NAME));
            }
            if (selectionPathElement instanceof SelectChildPattern) {
                SelectChildPattern selectChildPattern = (SelectChildPattern)selectionPathElement;
                String patternStr = selectChildPattern.patternStr();
                return builder.addPattern(this.buildPattern(new Some<String>(patternStr), ContainerFormats.PatternType.CHILD_PATTERN));
            }
            if (SelectParent$.MODULE$.equals(selectionPathElement)) {
                return builder.addPattern(this.buildPattern(None$.MODULE$, ContainerFormats.PatternType.PARENT));
            }
            throw new MatchError(selectionPathElement);
        });
        return builder.build().toByteArray();
    }

    private ContainerFormats.Selection.Builder buildPattern(Option<String> matcher, ContainerFormats.PatternType tpe) {
        ContainerFormats.Selection.Builder builder = ContainerFormats.Selection.newBuilder().setType(tpe);
        matcher.foreach((Function1<String, ContainerFormats.Selection.Builder> & Serializable & scala.Serializable)value -> builder.setMatcher((String)value));
        return builder;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        ContainerFormats.SelectionEnvelope selectionEnvelope = ContainerFormats.SelectionEnvelope.parseFrom(bytes);
        String manifest2 = selectionEnvelope.hasMessageManifest() ? selectionEnvelope.getMessageManifest().toStringUtf8() : "";
        Object msg = this.serialization().deserialize(selectionEnvelope.getEnclosedMessage().toByteArray(), selectionEnvelope.getSerializerId(), manifest2).get();
        Iterable elements = ((IterableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(selectionEnvelope.getPatternList()).asScala()).iterator().map((Function1<ContainerFormats.Selection, Product> & Serializable & scala.Serializable)x -> {
            ContainerFormats.PatternType patternType = x.getType();
            if (ContainerFormats.PatternType.CHILD_NAME.equals(patternType)) {
                return new SelectChildName(x.getMatcher());
            }
            if (ContainerFormats.PatternType.CHILD_PATTERN.equals(patternType)) {
                return new SelectChildPattern(x.getMatcher());
            }
            if (ContainerFormats.PatternType.PARENT.equals(patternType)) {
                return SelectParent$.MODULE$;
            }
            throw new MatchError(patternType);
        }).to(package$.MODULE$.genericCompanionToCBF(IndexedSeq$.MODULE$));
        boolean wildcardFanOut = selectionEnvelope.hasWildcardFanOut() ? selectionEnvelope.getWildcardFanOut() : false;
        return new ActorSelectionMessage(msg, elements, wildcardFanOut);
    }

    public MessageContainerSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        BaseSerializer.$init$(this);
    }
}

