/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.actor.Address;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.artery.ArterySettings;
import akka.remote.artery.InboundContext;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.compress.CompressionTable;
import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.CountMinSketch;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.remote.artery.compress.InboundCompression$;
import akka.remote.artery.compress.InboundCompression$Tables$;
import akka.remote.artery.compress.TopHeavyHitters;
import akka.remote.artery.compress.UnknownCompressedIdException;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u001duA\u0002\"D\u0011\u000395J\u0002\u0004N\u0007\"\u0005qI\u0014\u0005\u0006+\u0006!\ta\u0016\u0005\b1\u0006\u0011\r\u0011\"\u0002Z\u0011\u0019a\u0016\u0001)A\u00075\u001e)Q,\u0001E\u0001=\u001a)\u0001-\u0001E\u0001C\")QK\u0002C\u0001K\")aM\u0002C\u0001O\"I!\u0011\u0003\u0004\u0002\u0002\u0013\u0005%1\u0003\u0005\n\u0005_1\u0011\u0011!CA\u0005cA\u0011Ba\u0014\u0007\u0003\u0003%IA!\u0015\u0007\t\u0001\f!I\u001b\u0005\t_2\u0011)\u001a!C\u0001a\"I\u0011q\u0003\u0007\u0003\u0012\u0003\u0006I!\u001d\u0005\u000b\u00033a!Q3A\u0005\u0002\u0005m\u0001\"CA\u000f\u0019\tE\t\u0015!\u0003~\u0011)\ty\u0002\u0004BK\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003Ca!\u0011#Q\u0001\nuD!\"a\t\r\u0005+\u0007I\u0011AA\u0013\u0011)\t\u0019\u0004\u0004B\tB\u0003%\u0011q\u0005\u0005\u000b\u0003ka!Q3A\u0005\u0002\u0005]\u0002BCA \u0019\tE\t\u0015!\u0003\u0002:!1Q\u000b\u0004C\u0001\u0003\u0003Bq!a\u0014\r\t\u0003\t\t\u0006C\u0004\u0002d1!\t!!\u001a\t\u0013\u0005\u001dD\"!A\u0005\u0002\u0005%\u0004\"CAC\u0019E\u0005I\u0011AAD\u0011%\t\t\u000bDI\u0001\n\u0003\t\u0019\u000bC\u0005\u0002,2\t\n\u0011\"\u0001\u0002.\"I\u0011\u0011\u0017\u0007\u0012\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003wc\u0011\u0013!C\u0001\u0003{C\u0011\"!2\r\u0003\u0003%\t%a2\t\u0013\u0005eG\"!A\u0005\u0002\u0005]\u0002\"CAn\u0019\u0005\u0005I\u0011AAo\u0011%\t\u0019\u000fDA\u0001\n\u0003\n)\u000fC\u0005\u0002t2\t\t\u0011\"\u0001\u0002v\"I\u0011q \u0007\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u0007a\u0011\u0011!C!\u0005\u000bA\u0011Ba\u0002\r\u0003\u0003%\tE!\u0003\u0007\u000f5\u001b\u0015\u0011A$\u0003Z!Q!Q\f\u0015\u0003\u0006\u0004%\tAa\u0018\t\u0015\t5\u0004F!A!\u0002\u0013\u0011\t\u0007\u0003\u0006\u0003p!\u0012)\u0019!C\u0001\u0005cB!Ba!)\u0005\u0003\u0005\u000b\u0011\u0002B:\u0011)\u0011)\t\u000bBC\u0002\u0013\u0005!q\u0011\u0005\u000b\u0005\u001fC#\u0011!Q\u0001\n\t%\u0005B\u0003BIQ\t\u0005\t\u0015!\u0003\u0003\u0014\"Q!\u0011\u0014\u0015\u0003\u0006\u0004%\tAa'\t\u0015\t=\u0006F!A!\u0002\u0013\u0011i\n\u0003\u0004VQ\u0011\u0005!\u0011\u0017\u0005\t\u0005\u007fC\u0003\u0015)\u0003\u0003B\"A!Q\u0019\u0015!B\u0013\t9\u0010\u0003\u0005\u0003P\"\u0002\u000b\u0015BA\u001d\u0011!\u0011\t\u000e\u000bQ\u0001\n\u0005e\u0002\u0002\u0003BjQ\u0001\u0006IA!6\t\u000f\tm\u0007F\"\u0001\u0003^\"9!q\u001e\u0015\u0005\u0006\tE\bbBB\u0003Q\u0011\u00151q\u0001\u0005\b\u0007/AC\u0011AB\r\u0011\u001d\u0019Y\u0004\u000bC\u0005\u0007{A\u0001b!\u0012)\t\u000395q\t\u0005\b\u0007\u0013Bc\u0011CB&\u0011\u001d\u0019i\u0006\u000bC\u0005\u0007?Bqa!\u001a)\t#\u00199\u0007C\u0004\u0003\u0004!\"\te!!\u0002%%s'm\\;oI\u000e{W\u000e\u001d:fgNLwN\u001c\u0006\u0003\t\u0016\u000b\u0001bY8naJ,7o\u001d\u0006\u0003\r\u001e\u000ba!\u0019:uKJL(B\u0001%J\u0003\u0019\u0011X-\\8uK*\t!*\u0001\u0003bW.\f\u0007C\u0001'\u0002\u001b\u0005\u0019%AE%oE>,h\u000eZ\"p[B\u0014Xm]:j_:\u001c\"!A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A&\u0002'-+W\r](mIR\u000b'\r\\3t\u001dVl'-\u001a:\u0016\u0003i{\u0011aW\u000f\u0002\u0007\u0005!2*Z3q\u001f2$G+\u00192mKNtU/\u001c2fe\u0002\na\u0001V1cY\u0016\u001c\bCA0\u0007\u001b\u0005\t!A\u0002+bE2,7oE\u0002\u0007\u001f\n\u0004\"\u0001U2\n\u0005\u0011\f&\u0001D*fe&\fG.\u001b>bE2,G#\u00010\u0002\u000b\u0015l\u0007\u000f^=\u0016\u0007!\u0014y!F\u0001j!\u0011yFB!\u0004\u0016\u0007-\f)a\u0005\u0003\r\u001f2\u0014\u0007C\u0001)n\u0013\tq\u0017KA\u0004Qe>$Wo\u0019;\u0002\u0013=dG\rV1cY\u0016\u001cX#A9\u0011\u0007ITXP\u0004\u0002tq:\u0011Ao^\u0007\u0002k*\u0011aOV\u0001\u0007yI|w\u000e\u001e \n\u0003IK!!_)\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0005\u0019&\u001cHO\u0003\u0002z#B!AJ`A\u0001\u0013\ty8I\u0001\nEK\u000e|W\u000e\u001d:fgNLwN\u001c+bE2,\u0007\u0003BA\u0002\u0003\u000ba\u0001\u0001B\u0004\u0002\b1\u0011\r!!\u0003\u0003\u0003Q\u000bB!a\u0003\u0002\u0012A\u0019\u0001+!\u0004\n\u0007\u0005=\u0011KA\u0004O_RD\u0017N\\4\u0011\u0007A\u000b\u0019\"C\u0002\u0002\u0016E\u00131!\u00118z\u0003)yG\u000e\u001a+bE2,7\u000fI\u0001\fC\u000e$\u0018N^3UC\ndW-F\u0001~\u00031\t7\r^5wKR\u000b'\r\\3!\u0003%qW\r\u001f;UC\ndW-\u0001\u0006oKb$H+\u00192mK\u0002\nq#\u00193wKJ$\u0018n]3nK:$\u0018J\u001c)s_\u001e\u0014Xm]:\u0016\u0005\u0005\u001d\u0002#\u0002)\u0002*\u00055\u0012bAA\u0016#\n1q\n\u001d;j_:\u0004R\u0001TA\u0018\u0003\u0003I1!!\rD\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8UC\ndW-\u0001\rbIZ,'\u000f^5tK6,g\u000e^%o!J|wM]3tg\u0002\nQb[3fa>cG\rV1cY\u0016\u001cXCAA\u001d!\r\u0001\u00161H\u0005\u0004\u0003{\t&aA%oi\u0006q1.Z3q\u001f2$G+\u00192mKN\u0004C\u0003DA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0003\u0003B0\r\u0003\u0003AQa\\\fA\u0002EDa!!\u0007\u0018\u0001\u0004i\bBBA\u0010/\u0001\u0007Q\u0010C\u0004\u0002$]\u0001\r!a\n\t\u000f\u0005Ur\u00031\u0001\u0002:\u0005Y1/\u001a7fGR$\u0016M\u00197f)\u0011\t\u0019&a\u0018\u0011\u000b\u0005U\u00131L?\u000e\u0005\u0005]#bAA-\u0013\u0006!Q\u000f^5m\u0013\u0011\ti&a\u0016\u0003\u0013=\u0003H/[8o-\u0006d\u0007bBA11\u0001\u0007\u0011\u0011H\u0001\bm\u0016\u00148/[8o\u0003M\u0019H/\u0019:u+NLgn\u001a(fqR$\u0016M\u00197f)\t\t\u0019%\u0001\u0003d_BLX\u0003BA6\u0003c\"B\"!\u001c\u0002t\u0005e\u00141PA?\u0003\u0007\u0003Ba\u0018\u0007\u0002pA!\u00111AA9\t\u001d\t9A\u0007b\u0001\u0003\u0013A\u0001b\u001c\u000e\u0011\u0002\u0003\u0007\u0011Q\u000f\t\u0005ej\f9\b\u0005\u0003M}\u0006=\u0004\"CA\r5A\u0005\t\u0019AA<\u0011%\tyB\u0007I\u0001\u0002\u0004\t9\bC\u0005\u0002$i\u0001\n\u00111\u0001\u0002\u0000A)\u0001+!\u000b\u0002\u0002B)A*a\f\u0002p!I\u0011Q\u0007\u000e\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\tI)a(\u0016\u0005\u0005-%fA9\u0002\u000e.\u0012\u0011q\u0012\t\u0005\u0003#\u000bY*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001aF\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti*a%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0002\bm\u0011\r!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011QUAU+\t\t9KK\u0002~\u0003\u001b#q!a\u0002\u001d\u0005\u0004\tI!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005\u0015\u0016q\u0016\u0003\b\u0003\u000fi\"\u0019AA\u0005\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*B!!.\u0002:V\u0011\u0011q\u0017\u0016\u0005\u0003O\ti\tB\u0004\u0002\by\u0011\r!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU!\u0011qXAb+\t\t\tM\u000b\u0003\u0002:\u00055EaBA\u0004?\t\u0007\u0011\u0011B\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\u0005Y\u0006twM\u0003\u0002\u0002T\u0006!!.\u0019<b\u0013\u0011\t9.!4\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0005\u0002`\"I\u0011\u0011\u001d\u0012\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\bCBAu\u0003_\f\t\"\u0004\u0002\u0002l*\u0019\u0011Q^)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0006-(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a>\u0002~B\u0019\u0001+!?\n\u0007\u0005m\u0018KA\u0004C_>dW-\u00198\t\u0013\u0005\u0005H%!AA\u0002\u0005E\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002x\n-\u0001\"CAqO\u0005\u0005\t\u0019AA\t!\u0011\t\u0019Aa\u0004\u0005\u000f\u0005\u001d\u0001B1\u0001\u0002\n\u0005)\u0011\r\u001d9msV!!Q\u0003B\u000e)1\u00119B!\b\u0003$\t\u0015\"q\u0005B\u0017!\u0011yFB!\u0007\u0011\t\u0005\r!1\u0004\u0003\b\u0003\u000fI!\u0019AA\u0005\u0011\u0019y\u0017\u00021\u0001\u0003 A!!O\u001fB\u0011!\u0011aeP!\u0007\t\u000f\u0005e\u0011\u00021\u0001\u0003\"!9\u0011qD\u0005A\u0002\t\u0005\u0002bBA\u0012\u0013\u0001\u0007!\u0011\u0006\t\u0006!\u0006%\"1\u0006\t\u0006\u0019\u0006=\"\u0011\u0004\u0005\b\u0003kI\u0001\u0019AA\u001d\u0003\u001d)h.\u00199qYf,BAa\r\u0003DQ!!Q\u0007B%!\u0015\u0001\u0016\u0011\u0006B\u001c!5\u0001&\u0011\bB\u001f\u0005\u007f\u0011yD!\u0012\u0002:%\u0019!1H)\u0003\rQ+\b\u000f\\36!\u0011\u0011(Pa\u0010\u0011\t1s(\u0011\t\t\u0005\u0003\u0007\u0011\u0019\u0005B\u0004\u0002\b)\u0011\r!!\u0003\u0011\u000bA\u000bICa\u0012\u0011\u000b1\u000byC!\u0011\t\u0013\t-#\"!AA\u0002\t5\u0013a\u0001=%aA!q\f\u0004B!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tM\u0003\u0003BAf\u0005+JAAa\u0016\u0002N\n1qJ\u00196fGR,BAa\u0017\u0003&N\u0011\u0001fT\u0001\u0004Y><WC\u0001B1!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B4\u0013\u0006)QM^3oi&!!1\u000eB3\u00059aunZ4j]\u001e\fE-\u00199uKJ\fA\u0001\\8hA\u0005A1/\u001a;uS:<7/\u0006\u0002\u0003tA!!Q\u000fB?\u001d\u0011\u00119H!\u001f\u000e\u0003\u0015K1Aa\u001fF\u00039\t%\u000f^3ssN+G\u000f^5oONLAAa \u0003\u0002\nY1i\\7qe\u0016\u001c8/[8o\u0015\r\u0011Y(R\u0001\ng\u0016$H/\u001b8hg\u0002\n\u0011b\u001c:jO&tW+\u001b3\u0016\u0005\t%\u0005c\u0001)\u0003\f&\u0019!QR)\u0003\t1{gnZ\u0001\u000b_JLw-\u001b8VS\u0012\u0004\u0013AD5oE>,h\u000eZ\"p]R,\u0007\u0010\u001e\t\u0005\u0005o\u0012)*C\u0002\u0003\u0018\u0016\u0013a\"\u00138c_VtGmQ8oi\u0016DH/\u0001\u0007iK\u00064\u0018\u0010S5ui\u0016\u00148/\u0006\u0002\u0003\u001eB)AJa(\u0003$&\u0019!\u0011U\"\u0003\u001fQ{\u0007\u000fS3bmfD\u0015\u000e\u001e;feN\u0004B!a\u0001\u0003&\u00129\u0011q\u0001\u0015C\u0002\t\u001d\u0016\u0003\u0002BU\u0003#\u00012\u0001\u0015BV\u0013\r\u0011i+\u0015\u0002\u0005\u001dVdG.A\u0007iK\u00064\u0018\u0010S5ui\u0016\u00148\u000f\t\u000b\r\u0005g\u0013)La.\u0003:\nm&Q\u0018\t\u0005\u0019\"\u0012\u0019\u000bC\u0004\u0003^I\u0002\rA!\u0019\t\u000f\t=$\u00071\u0001\u0003t!9!Q\u0011\u001aA\u0002\t%\u0005b\u0002BIe\u0001\u0007!1\u0013\u0005\b\u00053\u0013\u0004\u0019\u0001BO\u0003\u0019!\u0018M\u00197fgB)!1\u0019\u0007\u0003$:\u0011A\nA\u0001\u0006C2Lg/\u001a\u0015\u0004i\t%\u0007c\u0001)\u0003L&\u0019!QZ)\u0003\u0011Y|G.\u0019;jY\u0016\f1B]3tK:$7i\\;oi\u0006qQ.\u0019=SKN,g\u000eZ\"pk:$\u0018aA2ngB\u0019AJa6\n\u0007\te7I\u0001\bD_VtG/T5o'.,Go\u00195\u0002\u0015\u0011,7m\\7qe\u0016\u001c8\u000f\u0006\u0004\u0003`\n\u0005(1\u001e\t\u0007\u0003+\nYFa)\t\u000f\t\r\b\b1\u0001\u0003f\u0006!\u0012N\\2p[&tw\rV1cY\u00164VM]:j_:\u00042\u0001\u0015Bt\u0013\r\u0011I/\u0015\u0002\u0005\u0005f$X\rC\u0004\u0003nb\u0002\r!!\u000f\u0002\u0007%$\u00070\u0001\neK\u000e|W\u000e\u001d:fgNLe\u000e^3s]\u0006dG\u0003\u0003Bp\u0005g\u0014)Pa>\t\u000f\t\r\u0018\b1\u0001\u0003f\"9!Q^\u001dA\u0002\u0005e\u0002b\u0002B}s\u0001\u0007\u0011\u0011H\u0001\u000fCR$X-\u001c9u\u0007>,h\u000e^3sQ\rI$Q \t\u0005\u0005\u007f\u001c\t!\u0004\u0002\u0002\u0018&!11AAL\u0005\u001d!\u0018-\u001b7sK\u000e\fAcY8oM&\u0014X.\u00113wKJ$\u0018n]3nK:$HCBB\u0005\u0007\u001f\u0019\u0019\u0002E\u0002Q\u0007\u0017I1a!\u0004R\u0005\u0011)f.\u001b;\t\u000f\rE!\b1\u0001\u0003f\u0006aA/\u00192mKZ+'o]5p]\"91Q\u0003\u001eA\u0002\u0005]\u0018AB4bm\u0016,\u0006/A\u0005j]\u000e\u0014X-\\3oiRA1\u0011BB\u000e\u0007g\u00199\u0004C\u0004\u0004\u001em\u0002\raa\b\u0002\u001bI,Wn\u001c;f\u0003\u0012$'/Z:t!\u0011\u0019\tca\n\u000e\u0005\r\r\"bAB\u0013\u0013\u0006)\u0011m\u0019;pe&!1\u0011FB\u0012\u0005\u001d\tE\r\u001a:fgNDCaa\u0007\u0004.A!\u0011QKB\u0018\u0013\u0011\u0019\t$a\u0016\u0003\rUtWo]3e\u0011\u001d\u0019)d\u000fa\u0001\u0005G\u000bQA^1mk\u0016Dqa!\u000f<\u0001\u0004\u0011I)A\u0001o\u0003\u0001\nG\rZ!oI\u000eCWmY6JM\",\u0017M^=ISR$XM\u001d#fi\u0016\u001cG/\u001a3\u0015\r\u0005]8qHB!\u0011\u001d\u0019)\u0004\u0010a\u0001\u0005GCqaa\u0011=\u0001\u0004\u0011I)A\u0003d_VtG/A\rsk:tU\r\u001f;UC\ndW-\u00113wKJ$\u0018n]3nK:$HCAB\u0005\u0003e\tGM^3si&\u001cXmQ8naJ,7o]5p]R\u000b'\r\\3\u0015\r\r%1QJB,\u0011\u001d\u0019yE\u0010a\u0001\u0007#\n1\"Y:t_\u000eL\u0017\r^5p]B!!qOB*\u0013\r\u0019)&\u0012\u0002\u0010\u001fV$(m\\;oI\u000e{g\u000e^3yi\"91\u0011\f A\u0002\rm\u0013!\u0002;bE2,\u0007#\u0002'\u00020\t\r\u0016a\b9sKB\f'/Z\"p[B\u0014Xm]:j_:\fEM^3si&\u001cX-\\3oiR!11LB1\u0011\u001d\u0019\u0019g\u0010a\u0001\u0005K\f\u0001C\\3yiR\u000b'\r\\3WKJ\u001c\u0018n\u001c8\u00025\t,\u0018\u000e\u001c3UC\ndWMR8s\u0003\u00124XM\u001d;jg\u0016lWM\u001c;\u0015\t\r%4\u0011\u0010\t\t\u0007W\u001a\u0019Ha)\u0002:9!1QNB8!\t!\u0018+C\u0002\u0004rE\u000ba\u0001\u0015:fI\u00164\u0017\u0002BB;\u0007o\u00121!T1q\u0015\r\u0019\t(\u0015\u0005\b\u0007w\u0002\u0005\u0019AB?\u0003!)G.Z7f]R\u001c\b#\u0002:\u0004\u0000\t\r\u0016bAAyyR\u001111\u0011\t\u0005\u0007W\u001a))\u0003\u0003\u0002X\u000e]\u0004")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        byte activeVersion;
        Tables<T> current;
        while (true) {
            if (attemptCounter > 2) {
                throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
            }
            current = this.tables;
            activeVersion = current.activeTable().version();
            if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                OptionVal$.MODULE$.None();
                return null;
            }
            DecompressionTable<T> decompressionTable = current.selectTable(incomingTableVersion);
            DecompressionTable<T> decompressionTable2 = OptionVal$Some$.MODULE$.unapply(decompressionTable);
            if (!OptionVal$.MODULE$.isEmpty$extension(decompressionTable2)) {
                DecompressionTable<T> selectedTable = OptionVal$.MODULE$.get$extension(decompressionTable2);
                T value = selectedTable.get(idx);
                if (value != null) {
                    return OptionVal$Some$.MODULE$.apply(value);
                }
                throw new UnknownCompressedIdException(idx);
            }
            if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
            this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(current.nextTable().version()));
            this.confirmAdvertisement(incomingTableVersion, false);
            ++attemptCounter;
        }
        this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", BoxesRunTime.boxToLong(this.originUid()), (Object)BoxesRunTime.boxToByte(activeVersion), (Object)BoxesRunTime.boxToByte(current.nextTable().version()), (Object)BoxesRunTime.boxToByte(incomingTableVersion));
        OptionVal$.MODULE$.None();
        return null;
    }

    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", gaveUp ? "Gave up" : "Confirmed", BoxesRunTime.boxToByte(tableVersion), BoxesRunTime.boxToLong(this.originUid()));
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", gaveUp ? "Gave up" : "Confirmed", BoxesRunTime.boxToByte(tableVersion), BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()));
            return;
        }
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext = this.inboundContext.association(this.originUid());
            OutboundContext outboundContext2 = OptionVal$Some$.MODULE$.unapply(outboundContext);
            if (!OptionVal$.MODULE$.isEmpty$extension(outboundContext2)) {
                BoxedUnit boxedUnit;
                OutboundContext association = OptionVal$.MODULE$.get$extension(outboundContext2);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$1 = this.tables;
                    DecompressionTable<T> x$1 = table.invert();
                    Some<CompressionTable<T>> x$2 = new Some<CompressionTable<T>>(table);
                    List<DecompressionTable<T>> x$3 = qual$1.copy$default$1();
                    DecompressionTable<T> x$4 = qual$1.copy$default$2();
                    int x$5 = qual$1.copy$default$5();
                    Tables<T> nextState = qual$1.copy(x$3, x$4, x$1, x$2, x$5);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", Logging$.MODULE$.simpleName(this.tables.activeTable()), BoxesRunTime.boxToLong(this.originUid()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", BoxesRunTime.boxToLong(this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext = this.inboundContext.association(this.originUid());
                OutboundContext outboundContext3 = OptionVal$Some$.MODULE$.unapply(outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension(outboundContext3)) {
                    OutboundContext association = OptionVal$.MODULE$.get$extension(outboundContext3);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()), BoxesRunTime.boxToInteger(this.resendCount), BoxesRunTime.boxToInteger(this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()));
            this.confirmAdvertisement(inProgress.version(), true);
            return;
        }
        throw new MatchError(option);
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Map<T, Object> mappings = this.buildTableForAdvertisement(this.heavyHitters().iterator());
        return CompressionTable$.MODULE$.apply(this.originUid(), nextTableVersion, mappings);
    }

    public Map<T, Object> buildTableForAdvertisement(Iterator<T> elements) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq(elements.zipWithIndex());
        return mb.result();
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == current$1.advertisementInProgress().get().version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings2, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings2;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", Logging$.MODULE$.simpleName(this.getClass()), BoxesRunTime.boxToLong(originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        public DecompressionTable<T> selectTable(int version) {
            if (this.activeTable().version() == version) {
                return OptionVal$Some$.MODULE$.apply(this.activeTable());
            }
            DecompressionTable found = this.find$1(this.oldTables(), version);
            return found;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            byte x$1 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$2 = qual$1.copy$default$1();
            Object x$3 = qual$1.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$1.copy(x$2, x$1, x$3), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        @Override
        public String productPrefix() {
            return "Tables";
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.oldTables();
                }
                case 1: {
                    return this.activeTable();
                }
                case 2: {
                    return this.nextTable();
                }
                case 3: {
                    return this.advertisementInProgress();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger(this.keepOldTables());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, Statics.anyHash(this.oldTables()));
            n = Statics.mix(n, Statics.anyHash(this.activeTable()));
            n = Statics.mix(n, Statics.anyHash(this.nextTable()));
            n = Statics.mix(n, Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix(n, this.keepOldTables());
            return Statics.finalizeHash(n, 5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            return true;
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            List list;
            while (true) {
                if (((Object)Nil$.MODULE$).equals(list = tables)) {
                    OptionVal$.MODULE$.None();
                    return null;
                }
                if (!(list instanceof $colon$colon)) break;
                $colon$colon $colon$colon = ($colon$colon)list;
                DecompressionTable t = (DecompressionTable)$colon$colon.head();
                List tail = $colon$colon.tl$access$1();
                if (t.version() == version$1) {
                    return OptionVal$Some$.MODULE$.apply(t);
                }
                tables = tail;
            }
            throw new MatchError(list);
        }

        private static final byte incrementTableVersion$1(byte version) {
            if (version == 127) {
                return 0;
            }
            return (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$(this);
        }
    }
}

