/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.remote.UniqueAddress;
import akka.remote.artery.InboundContext;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.SystemMessageAcker$;
import akka.remote.artery.SystemMessageDelivery;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.StageLogging;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t<aa\u0004\t\t\u0002Q1bA\u0002\r\u0011\u0011\u0003!\u0012\u0004C\u0003!\u0003\u0011\u0005!\u0005C\u0004$\u0003\t\u0007I\u0011\u0001\u0013\t\r!\n\u0001\u0015!\u0003&\r\u0015A\u0002\u0003\u0001\n2\u0011!\tUA!A!\u0002\u0013\u0011\u0005\"\u0002\u0011\u0006\t\u0003)\u0005b\u0002%\u0006\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0016\u0001\u000b\u0011\u0002&\t\u000f9+!\u0019!C\u0001\u001f\"11+\u0002Q\u0001\nACq\u0001V\u0003C\u0002\u0013\u0005S\u000b\u0003\u0004W\u000b\u0001\u0006IA\u000f\u0005\u0006/\u0016!\t\u0005W\u0001\u0013'f\u001cH/Z7NKN\u001c\u0018mZ3BG.,'O\u0003\u0002\u0012%\u00051\u0011M\u001d;fefT!a\u0005\u000b\u0002\rI,Wn\u001c;f\u0015\u0005)\u0012\u0001B1lW\u0006\u0004\"aF\u0001\u000e\u0003A\u0011!cU=ti\u0016lW*Z:tC\u001e,\u0017iY6feN\u0011\u0011A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012AF\u0001\"\u001b\u0006Dh*Z4bi&4X-Q2l]><H.\u001a3hK6,g\u000e\u001e'pO\u001eLgnZ\u000b\u0002KA\u00111DJ\u0005\u0003Oq\u00111!\u00138u\u0003\tj\u0015\r\u001f(fO\u0006$\u0018N^3BG.twn\u001e7fI\u001e,W.\u001a8u\u0019><w-\u001b8hA!\u0012\u0011A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[Q\t!\"\u00198o_R\fG/[8o\u0013\tyCFA\u0006J]R,'O\\1m\u0003BL\u0007F\u0001\u0001+'\t)!\u0007E\u00024qij\u0011\u0001\u000e\u0006\u0003kY\nQa\u001d;bO\u0016T!a\u000e\u000b\u0002\rM$(/Z1n\u0013\tIDG\u0001\u0006He\u0006\u0004\bn\u0015;bO\u0016\u0004Ba\u000f\u001f?}5\ta'\u0003\u0002>m\tIa\t\\8x'\"\f\u0007/\u001a\t\u0003/}J!\u0001\u0011\t\u0003\u001f%s'm\\;oI\u0016sg/\u001a7pa\u0016\fa\"\u001b8c_VtGmQ8oi\u0016DH\u000f\u0005\u0002\u0018\u0007&\u0011A\t\u0005\u0002\u000f\u0013:\u0014w.\u001e8e\u0007>tG/\u001a=u)\t1u\t\u0005\u0002\u0018\u000b!)\u0011i\u0002a\u0001\u0005\u0006\u0011\u0011N\\\u000b\u0002\u0015B\u00191h\u0013 \n\u000513$!B%oY\u0016$\u0018aA5oA\u0005\u0019q.\u001e;\u0016\u0003A\u00032aO)?\u0013\t\u0011fG\u0001\u0004PkRdW\r^\u0001\u0005_V$\b%A\u0003tQ\u0006\u0004X-F\u0001;\u0003\u0019\u0019\b.\u00199fA\u0005Y1M]3bi\u0016dunZ5d)\tIF\f\u0005\u000245&\u00111\f\u000e\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\")QL\u0004a\u0001=\u0006\u0019\u0012N\u001c5fe&$X\rZ!uiJL'-\u001e;fgB\u00111hX\u0005\u0003AZ\u0012!\"\u0011;ue&\u0014W\u000f^3tQ\t)!\u0006")
@InternalApi
public class SystemMessageAcker
extends GraphStage<FlowShape<InboundEnvelope, InboundEnvelope>> {
    public final InboundContext akka$remote$artery$SystemMessageAcker$$inboundContext;
    private final Inlet<InboundEnvelope> in;
    private final Outlet<InboundEnvelope> out;
    private final FlowShape<InboundEnvelope, InboundEnvelope> shape;

    public static int MaxNegativeAcknowledgementLogging() {
        return SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging();
    }

    public Inlet<InboundEnvelope> in() {
        return this.in;
    }

    public Outlet<InboundEnvelope> out() {
        return this.out;
    }

    @Override
    public FlowShape<InboundEnvelope, InboundEnvelope> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private Map<UniqueAddress, Object> sequenceNumbers;
            private int nackCount;
            private LoggingAdapter akka$stream$stage$StageLogging$$_log;
            private final /* synthetic */ SystemMessageAcker $outer;

            public LoggingAdapter log() {
                return StageLogging.log$(this);
            }

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$(this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            public LoggingAdapter akka$stream$stage$StageLogging$$_log() {
                return this.akka$stream$stage$StageLogging$$_log;
            }

            public void akka$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.akka$stream$stage$StageLogging$$_log = x$1;
            }

            private Map<UniqueAddress, Object> sequenceNumbers() {
                return this.sequenceNumbers;
            }

            private void sequenceNumbers_$eq(Map<UniqueAddress, Object> x$1) {
                this.sequenceNumbers = x$1;
            }

            private int nackCount() {
                return this.nackCount;
            }

            private void nackCount_$eq(int x$1) {
                this.nackCount = x$1;
            }

            private UniqueAddress localAddress() {
                return this.$outer.akka$remote$artery$SystemMessageAcker$$inboundContext.localAddress();
            }

            public Class<?> logSource() {
                return SystemMessageAcker.class;
            }

            public void onPush() {
                InboundEnvelope env = this.grab(this.$outer.in());
                Object object = env.message();
                if (object instanceof SystemMessageDelivery.SystemMessageEnvelope) {
                    long l;
                    SystemMessageDelivery.SystemMessageEnvelope systemMessageEnvelope = (SystemMessageDelivery.SystemMessageEnvelope)object;
                    long n = systemMessageEnvelope.seqNo();
                    UniqueAddress ackReplyTo = systemMessageEnvelope.ackReplyTo();
                    Option<V> option = this.sequenceNumbers().get(ackReplyTo);
                    if (None$.MODULE$.equals(option)) {
                        l = 1L;
                    } else if (option instanceof Some) {
                        long seqNo;
                        Some some = (Some)option;
                        l = seqNo = BoxesRunTime.unboxToLong(some.value());
                    } else {
                        throw new MatchError(option);
                    }
                    long expectedSeqNo = l;
                    if (n == expectedSeqNo) {
                        this.$outer.akka$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Ack(n, this.localAddress()));
                        this.sequenceNumbers_$eq(this.sequenceNumbers().updated(ackReplyTo, BoxesRunTime.boxToLong(n + 1L)));
                        InboundEnvelope unwrapped = env.withMessage(systemMessageEnvelope.message());
                        this.push(this.$outer.out(), unwrapped);
                        return;
                    }
                    if (n < expectedSeqNo) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("Deduplicate system message [{}] from [{}], expected [{}]", BoxesRunTime.boxToLong(n), $anon$2.fromRemoteAddressStr$1(env), BoxesRunTime.boxToLong(expectedSeqNo));
                        }
                        this.$outer.akka$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Ack(expectedSeqNo - 1L, this.localAddress()));
                        this.pull(this.$outer.in());
                        return;
                    }
                    if (this.nackCount() < SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()) {
                        this.nackCount_$eq(this.nackCount() + 1);
                        String maxNackReached = this.nackCount() == SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging() ? new StringBuilder(53).append(". This happened [").append(SystemMessageAcker$.MODULE$.MaxNegativeAcknowledgementLogging()).append("] times and will not be logged more.").toString() : "";
                        this.log().warning("Sending negative acknowledgement of system message [{}] from [{}], highest acknowledged [{}]{}", BoxesRunTime.boxToLong(n), (Object)$anon$2.fromRemoteAddressStr$1(env), (Object)BoxesRunTime.boxToLong(expectedSeqNo - 1L), (Object)maxNackReached);
                    }
                    this.$outer.akka$remote$artery$SystemMessageAcker$$inboundContext.sendControl(ackReplyTo.address(), new SystemMessageDelivery.Nack(expectedSeqNo - 1L, this.localAddress()));
                    this.pull(this.$outer.in());
                    return;
                }
                this.push(this.$outer.out(), env);
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            private static final String fromRemoteAddressStr$1(InboundEnvelope env$1) {
                OutboundContext outboundContext = env$1.association();
                OutboundContext outboundContext2 = OptionVal$Some$.MODULE$.unapply(outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension(outboundContext2)) {
                    OutboundContext a = OptionVal$.MODULE$.get$extension(outboundContext2);
                    return a.remoteAddress().toString();
                }
                return "N/A";
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                StageLogging.$init$(this);
                this.sequenceNumbers = Predef$.MODULE$.Map().empty();
                this.nackCount = 0;
                this.setHandlers($outer.in(), $outer.out(), this);
            }
        };
    }

    public SystemMessageAcker(InboundContext inboundContext) {
        this.akka$remote$artery$SystemMessageAcker$$inboundContext = inboundContext;
        this.in = Inlet$.MODULE$.apply("SystemMessageAcker.in");
        this.out = Outlet$.MODULE$.apply("SystemMessageAcker.out");
        this.shape = new FlowShape<InboundEnvelope, InboundEnvelope>(this.in(), this.out());
    }
}

