/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.protobufv3.internal.ByteString;
import akka.remote.ByteStringUtils$;
import akka.remote.MessageSerializer;
import akka.remote.WireFormats;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.HeaderBuilder;
import akka.remote.artery.OutboundEnvelope;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@InternalApi
public final class MessageSerializer$ {
    public static MessageSerializer$ MODULE$;

    static {
        new MessageSerializer$();
    }

    public Object deserialize(ExtendedActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)SerializationExtension$.MODULE$.apply(system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    public WireFormats.SerializedMessage serialize(ExtendedActorSystem system, Object message) {
        WireFormats.SerializedMessage serializedMessage;
        Serialization s = (Serialization)SerializationExtension$.MODULE$.apply(system);
        Serializer serializer = s.findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        Serialization.Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            try {
                if (oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq(system.provider().serializationInformation());
                }
                builder.setMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(message)));
                builder.setSerializerId(serializer.identifier());
                String ms = Serializers$.MODULE$.manifestFor(serializer, message);
                Object object = new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty() ? builder.setMessageManifest(ByteString.copyFromUtf8(ms)) : BoxedUnit.UNIT;
                serializedMessage = builder.build();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    throw new MessageSerializer.SerializationException(new StringBuilder(58).append("Failed to serialize remote message [").append(message.getClass()).append("] ").append("using serializer [").append(serializer.getClass()).append("].").toString(), e);
                }
                throw throwable;
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return serializedMessage;
    }

    public void serializeForArtery(Serialization serialization, OutboundEnvelope outboundEnvelope, HeaderBuilder headerBuilder, EnvelopeBuffer envelope) {
        Object message = outboundEnvelope.message();
        Serializer serializer = serialization.findSerializerFor(message);
        Serialization.Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(serialization.serializationInformation());
            }
            headerBuilder.setSerializer(serializer.identifier());
            headerBuilder.setManifest(Serializers$.MODULE$.manifestFor(serializer, message));
            envelope.writeHeader(headerBuilder, outboundEnvelope);
            Serializer serializer2 = serializer;
            if (serializer2 instanceof ByteBufferSerializer) {
                Serializer serializer3 = serializer2;
                ((ByteBufferSerializer)((Object)serializer3)).toBinary(message, envelope.byteBuffer());
            } else {
                envelope.byteBuffer().put(serializer.toBinary(message));
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
    }

    public Object deserializeForArtery(ExtendedActorSystem system, long originUid, Serialization serialization, int serializer, String classManifest, EnvelopeBuffer envelope) {
        return serialization.deserializeByteBuffer(envelope.byteBuffer(), serializer, classManifest);
    }

    private MessageSerializer$() {
        MODULE$ = this;
    }
}

