/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcSystemLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PekkoRpcSystemLoaderITCase {
    private static final PekkoRpcSystemLoader LOADER = new PekkoRpcSystemLoader();

    PekkoRpcSystemLoaderITCase() {
    }

    @Test
    void testServiceLoadingWithDefaultConfig() {
        Configuration config = new Configuration();
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            Assertions.assertThat((Object)rpcSystem).isNotNull();
        }
    }

    @Test
    void testServiceLoadingWithNonExistingPath(@TempDir Path tempDir) {
        Configuration config = new Configuration();
        config.set(CoreOptions.TMP_DIRS, (Object)tempDir.resolve(Paths.get("some", "directory")).toString());
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            Assertions.assertThat((Object)rpcSystem).isNotNull();
        }
    }

    @Test
    void testServiceLoadingWithExistingLinkedPath(@TempDir Path tempDir) throws Exception {
        Configuration config = new Configuration();
        Path linkedDirectory = Paths.get(tempDir.toString(), "linkedDir");
        Path symbolicLink = Paths.get(tempDir.toString(), "symlink");
        Files.createSymbolicLink(symbolicLink, linkedDirectory, new FileAttribute[0]);
        Files.createDirectories(linkedDirectory.resolve("a").resolve("b"), new FileAttribute[0]);
        config.set(CoreOptions.TMP_DIRS, (Object)symbolicLink.resolve("a").resolve("b").toString());
        try (RpcSystem rpcSystem = LOADER.loadRpcSystem(config);){
            Assertions.assertThat((Object)rpcSystem).isNotNull();
        }
    }

    @Test
    void testServiceLoadingWithNonExistingLinkedPath(@TempDir Path tempDir) throws Exception {
        Configuration config = new Configuration();
        Path linkedDirectory = Paths.get(tempDir.toString(), "linkedDir");
        Path symbolicLink = Paths.get(tempDir.toString(), "symlink");
        Files.createSymbolicLink(symbolicLink, linkedDirectory, new FileAttribute[0]);
        config.set(CoreOptions.TMP_DIRS, (Object)symbolicLink.toString());
        Assertions.assertThatThrownBy(() -> LOADER.loadRpcSystem(config)).hasRootCauseInstanceOf(NoSuchFileException.class);
    }
}

