/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import com.google.protobuf.Descriptors;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializeFactory;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbCodegenUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PbCodegenUtils.class);

    public static String flinkContainerElementCode(String flinkContainerCode, String index, LogicalType eleType) {
        switch (eleType.getTypeRoot()) {
            case INTEGER: {
                return flinkContainerCode + ".getInt(" + index + ")";
            }
            case BIGINT: {
                return flinkContainerCode + ".getLong(" + index + ")";
            }
            case FLOAT: {
                return flinkContainerCode + ".getFloat(" + index + ")";
            }
            case DOUBLE: {
                return flinkContainerCode + ".getDouble(" + index + ")";
            }
            case BOOLEAN: {
                return flinkContainerCode + ".getBoolean(" + index + ")";
            }
            case VARCHAR: 
            case CHAR: {
                return flinkContainerCode + ".getString(" + index + ")";
            }
            case VARBINARY: 
            case BINARY: {
                return flinkContainerCode + ".getBinary(" + index + ")";
            }
            case ROW: {
                int size = eleType.getChildren().size();
                return flinkContainerCode + ".getRow(" + index + ", " + size + ")";
            }
            case MAP: {
                return flinkContainerCode + ".getMap(" + index + ")";
            }
            case ARRAY: {
                return flinkContainerCode + ".getArray(" + index + ")";
            }
        }
        throw new IllegalArgumentException("Unsupported data type in schema: " + String.valueOf(eleType));
    }

    public static String getTypeStrFromProto(Descriptors.FieldDescriptor fd, boolean isList) throws PbCodegenException {
        Object typeStr;
        switch (fd.getJavaType()) {
            case MESSAGE: {
                if (fd.isMapField()) {
                    Descriptors.FieldDescriptor keyFd = fd.getMessageType().findFieldByName("key");
                    Descriptors.FieldDescriptor valueFd = fd.getMessageType().findFieldByName("value");
                    String keyTypeStr = PbCodegenUtils.getTypeStrFromProto(keyFd, false);
                    String valueTypeStr = PbCodegenUtils.getTypeStrFromProto(valueFd, false);
                    typeStr = "Map<" + keyTypeStr + "," + valueTypeStr + ">";
                    break;
                }
                typeStr = PbFormatUtils.getFullJavaName(fd.getMessageType());
                break;
            }
            case INT: {
                typeStr = "Integer";
                break;
            }
            case LONG: {
                typeStr = "Long";
                break;
            }
            case STRING: {
                typeStr = "String";
                break;
            }
            case ENUM: {
                typeStr = PbFormatUtils.getFullJavaName(fd.getEnumType());
                break;
            }
            case FLOAT: {
                typeStr = "Float";
                break;
            }
            case DOUBLE: {
                typeStr = "Double";
                break;
            }
            case BYTE_STRING: {
                typeStr = "ByteString";
                break;
            }
            case BOOLEAN: {
                typeStr = "Boolean";
                break;
            }
            default: {
                throw new PbCodegenException("do not support field type: " + String.valueOf(fd.getJavaType()));
            }
        }
        if (isList) {
            return "List<" + (String)typeStr + ">";
        }
        return typeStr;
    }

    public static String getTypeStrFromLogicType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case INTEGER: {
                return "int";
            }
            case BIGINT: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case VARCHAR: 
            case CHAR: {
                return "StringData";
            }
            case VARBINARY: 
            case BINARY: {
                return "byte[]";
            }
            case ROW: {
                return "RowData";
            }
            case MAP: {
                return "MapData";
            }
            case ARRAY: {
                return "ArrayData";
            }
        }
        throw new IllegalArgumentException("Unsupported data type in schema: " + String.valueOf(type));
    }

    public static String pbDefaultValueCode(Descriptors.FieldDescriptor fieldDescriptor, PbFormatContext pbFormatContext) throws PbCodegenException {
        String nullLiteral = pbFormatContext.getPbFormatConfig().getWriteNullStringLiterals();
        switch (fieldDescriptor.getJavaType()) {
            case MESSAGE: {
                return PbFormatUtils.getFullJavaName(fieldDescriptor.getMessageType()) + ".getDefaultInstance()";
            }
            case INT: {
                return "0";
            }
            case LONG: {
                return "0L";
            }
            case STRING: {
                return "\"" + nullLiteral + "\"";
            }
            case ENUM: {
                return PbFormatUtils.getFullJavaName(fieldDescriptor.getEnumType()) + ".values()[0]";
            }
            case FLOAT: {
                return "0.0f";
            }
            case DOUBLE: {
                return "0.0d";
            }
            case BYTE_STRING: {
                return "ByteString.EMPTY";
            }
            case BOOLEAN: {
                return "false";
            }
        }
        throw new PbCodegenException("do not support field type: " + String.valueOf(fieldDescriptor.getJavaType()));
    }

    public static String convertFlinkArrayElementToPbWithDefaultValueCode(String flinkArrDataVar, String iVar, String resultPbVar, Descriptors.FieldDescriptor elementPbFd, LogicalType elementDataType, PbFormatContext pbFormatContext, int indent) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        String flinkElementVar = "elementVar" + uid;
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        String protoTypeStr = PbCodegenUtils.getTypeStrFromProto(elementPbFd, false);
        String dataTypeStr = PbCodegenUtils.getTypeStrFromLogicType(elementDataType);
        appender.appendLine(protoTypeStr + " " + resultPbVar);
        appender.begin("if(" + flinkArrDataVar + ".isNullAt(" + iVar + ")){");
        appender.appendLine(resultPbVar + "=" + PbCodegenUtils.pbDefaultValueCode(elementPbFd, pbFormatContext));
        appender.end("}else{");
        appender.begin();
        appender.appendLine(dataTypeStr + " " + flinkElementVar);
        String flinkContainerElementCode = PbCodegenUtils.flinkContainerElementCode(flinkArrDataVar, iVar, elementDataType);
        appender.appendLine(flinkElementVar + " = " + flinkContainerElementCode);
        PbCodegenSerializer codegenSer = PbCodegenSerializeFactory.getPbCodegenSer(elementPbFd, elementDataType, pbFormatContext);
        String code = codegenSer.codegen(resultPbVar, flinkElementVar, appender.currentIndent());
        appender.appendSegment(code);
        appender.end("}");
        return appender.code();
    }

    public static Class compileClass(ClassLoader classloader, String className, String code) throws ClassNotFoundException {
        SimpleCompiler simpleCompiler = new SimpleCompiler();
        simpleCompiler.setParentClassLoader(classloader);
        try {
            simpleCompiler.cook(code);
        }
        catch (Throwable t) {
            LOG.error("Protobuf codegen compile error: \n" + code);
            throw new InvalidProgramException("Program cannot be compiled. This is a bug. Please file an issue.", t);
        }
        return simpleCompiler.getClassLoader().loadClass(className);
    }

    public static boolean needToSplit(int noSplitCodeSize) {
        return noSplitCodeSize >= 4000;
    }
}

