/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.nohive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.table.PartitionFieldExtractor;
import org.apache.flink.orc.OrcColumnarRowInputFormat;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.orc.nohive.shim.OrcNoHiveShim;
import org.apache.flink.orc.nohive.vector.AbstractOrcNoHiveVector;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.vector.AbstractOrcColumnVector;
import org.apache.flink.orc.vector.ColumnBatchFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class OrcNoHiveColumnarRowInputFormat {
    private OrcNoHiveColumnarRowInputFormat() {
    }

    public static <SplitT extends FileSourceSplit> OrcColumnarRowInputFormat<?, SplitT> createPartitionedFormat(Configuration hadoopConfig, RowType tableType, List<String> partitionKeys, PartitionFieldExtractor<SplitT> extractor, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, Function<RowType, TypeInformation<RowData>> rowTypeInfoFactory) {
        String[] tableFieldNames = tableType.getFieldNames().toArray(new String[0]);
        LogicalType[] tableFieldTypes = tableType.getChildren().toArray(new LogicalType[0]);
        List orcFieldNames = OrcSplitReaderUtil.getNonPartNames((String[])tableFieldNames, partitionKeys);
        int[] orcSelectedFields = OrcSplitReaderUtil.getSelectedOrcFields((String[])tableFieldNames, (int[])selectedFields, (List)orcFieldNames);
        ColumnBatchFactory & Serializable batchGenerator = (ColumnBatchFactory & Serializable)(split, rowBatch) -> {
            ColumnVector[] vectors = new ColumnVector[selectedFields.length];
            for (int i = 0; i < vectors.length; ++i) {
                String name = tableFieldNames[selectedFields[i]];
                LogicalType type = tableFieldTypes[selectedFields[i]];
                vectors[i] = partitionKeys.contains(name) ? AbstractOrcColumnVector.createFlinkVectorFromConstant((LogicalType)type, (Object)extractor.extract(split, name, type), (int)batchSize) : AbstractOrcNoHiveVector.createFlinkVector(rowBatch.cols[orcFieldNames.indexOf(name)]);
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new OrcColumnarRowInputFormat((OrcShim)new OrcNoHiveShim(), hadoopConfig, OrcSplitReaderUtil.convertToOrcTypeWithPart((String[])tableFieldNames, (LogicalType[])tableFieldTypes, partitionKeys), orcSelectedFields, conjunctPredicates, batchSize, (ColumnBatchFactory)batchGenerator, rowTypeInfoFactory.apply(new RowType(Arrays.stream(selectedFields).mapToObj(i -> (RowType.RowField)tableType.getFields().get(i)).collect(Collectors.toList()))));
    }
}

