/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.Union;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.base.CoGroupRawOperatorBase;
import org.apache.flink.api.common.operators.base.CollectorMapOperatorBase;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.api.common.operators.base.FilterOperatorBase;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.common.operators.base.GroupCombineOperatorBase;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.MapPartitionOperatorBase;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.operators.base.SortPartitionOperatorBase;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.dag.BinaryUnionNode;
import org.apache.flink.optimizer.dag.BulkIterationNode;
import org.apache.flink.optimizer.dag.BulkPartialSolutionNode;
import org.apache.flink.optimizer.dag.CoGroupNode;
import org.apache.flink.optimizer.dag.CoGroupRawNode;
import org.apache.flink.optimizer.dag.CollectorMapNode;
import org.apache.flink.optimizer.dag.CrossNode;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.DataSinkNode;
import org.apache.flink.optimizer.dag.DataSourceNode;
import org.apache.flink.optimizer.dag.FilterNode;
import org.apache.flink.optimizer.dag.FlatMapNode;
import org.apache.flink.optimizer.dag.GroupCombineNode;
import org.apache.flink.optimizer.dag.GroupReduceNode;
import org.apache.flink.optimizer.dag.JoinNode;
import org.apache.flink.optimizer.dag.MapNode;
import org.apache.flink.optimizer.dag.MapPartitionNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.PartitionNode;
import org.apache.flink.optimizer.dag.ReduceNode;
import org.apache.flink.optimizer.dag.SolutionSetNode;
import org.apache.flink.optimizer.dag.SortPartitionNode;
import org.apache.flink.optimizer.dag.WorksetIterationNode;
import org.apache.flink.optimizer.dag.WorksetNode;
import org.apache.flink.optimizer.traversals.StaticDynamicPathIdentifier;
import org.apache.flink.optimizer.traversals.StepFunctionValidator;
import org.apache.flink.util.Visitor;

public class GraphCreatingVisitor
implements Visitor<Operator<?>> {
    private final Map<Operator<?>, OptimizerNode> con2node;
    private final List<DataSinkNode> sinks;
    private final int defaultParallelism;
    private final GraphCreatingVisitor parent;
    private final ExecutionMode defaultDataExchangeMode;
    private final boolean forceParallelism;

    public GraphCreatingVisitor(int defaultParallelism, ExecutionMode defaultDataExchangeMode) {
        this(null, false, defaultParallelism, defaultDataExchangeMode, null);
    }

    private GraphCreatingVisitor(GraphCreatingVisitor parent, boolean forceParallelism, int defaultParallelism, ExecutionMode dataExchangeMode, HashMap<Operator<?>, OptimizerNode> closure) {
        this.con2node = closure == null ? new HashMap() : closure;
        this.sinks = new ArrayList<DataSinkNode>(2);
        this.defaultParallelism = defaultParallelism;
        this.parent = parent;
        this.defaultDataExchangeMode = dataExchangeMode;
        this.forceParallelism = forceParallelism;
    }

    public List<DataSinkNode> getSinks() {
        return this.sinks;
    }

    public boolean preVisit(Operator<?> c) {
        BulkIterationBase.PartialSolutionPlaceHolder holder;
        OptimizerNode n;
        if (this.con2node.containsKey(c)) {
            return false;
        }
        if (c instanceof GenericDataSinkBase) {
            DataSinkNode dsn = new DataSinkNode((GenericDataSinkBase)c);
            this.sinks.add(dsn);
            n = dsn;
        } else if (c instanceof GenericDataSourceBase) {
            n = new DataSourceNode((GenericDataSourceBase)c);
        } else if (c instanceof MapOperatorBase) {
            n = new MapNode((SingleInputOperator<?, ?, ?>)((MapOperatorBase)c));
        } else if (c instanceof MapPartitionOperatorBase) {
            n = new MapPartitionNode((SingleInputOperator<?, ?, ?>)((MapPartitionOperatorBase)c));
        } else if (c instanceof CollectorMapOperatorBase) {
            n = new CollectorMapNode((SingleInputOperator<?, ?, ?>)((CollectorMapOperatorBase)c));
        } else if (c instanceof FlatMapOperatorBase) {
            n = new FlatMapNode((FlatMapOperatorBase)c);
        } else if (c instanceof FilterOperatorBase) {
            n = new FilterNode((FilterOperatorBase)c);
        } else if (c instanceof ReduceOperatorBase) {
            n = new ReduceNode((ReduceOperatorBase)c);
        } else if (c instanceof GroupCombineOperatorBase) {
            n = new GroupCombineNode((GroupCombineOperatorBase)c);
        } else if (c instanceof GroupReduceOperatorBase) {
            n = new GroupReduceNode((GroupReduceOperatorBase)c);
        } else if (c instanceof JoinOperatorBase) {
            n = new JoinNode((JoinOperatorBase)c);
        } else if (c instanceof CoGroupOperatorBase) {
            n = new CoGroupNode((CoGroupOperatorBase)c);
        } else if (c instanceof CoGroupRawOperatorBase) {
            n = new CoGroupRawNode((CoGroupRawOperatorBase)c);
        } else if (c instanceof CrossOperatorBase) {
            n = new CrossNode((CrossOperatorBase)c);
        } else if (c instanceof BulkIterationBase) {
            n = new BulkIterationNode((BulkIterationBase)c);
        } else if (c instanceof DeltaIterationBase) {
            n = new WorksetIterationNode((DeltaIterationBase)c);
        } else if (c instanceof Union) {
            n = new BinaryUnionNode((Union)c);
        } else if (c instanceof PartitionOperatorBase) {
            n = new PartitionNode((PartitionOperatorBase)c);
        } else if (c instanceof SortPartitionOperatorBase) {
            n = new SortPartitionNode((SortPartitionOperatorBase)c);
        } else if (c instanceof BulkIterationBase.PartialSolutionPlaceHolder) {
            if (this.parent == null) {
                throw new InvalidProgramException("It is currently not supported to create data sinks inside iterations.");
            }
            holder = (BulkIterationBase.PartialSolutionPlaceHolder)c;
            BulkIterationBase enclosingIteration = holder.getContainingBulkIteration();
            BulkIterationNode containingIterationNode = (BulkIterationNode)this.parent.con2node.get(enclosingIteration);
            BulkPartialSolutionNode p = new BulkPartialSolutionNode(holder, containingIterationNode);
            p.setParallelism(containingIterationNode.getParallelism());
            n = p;
        } else if (c instanceof DeltaIterationBase.WorksetPlaceHolder) {
            if (this.parent == null) {
                throw new InvalidProgramException("It is currently not supported to create data sinks inside iterations.");
            }
            holder = (DeltaIterationBase.WorksetPlaceHolder)c;
            DeltaIterationBase enclosingIteration = holder.getContainingWorksetIteration();
            WorksetIterationNode containingIterationNode = (WorksetIterationNode)this.parent.con2node.get(enclosingIteration);
            WorksetNode p = new WorksetNode((DeltaIterationBase.WorksetPlaceHolder<?>)holder, containingIterationNode);
            p.setParallelism(containingIterationNode.getParallelism());
            n = p;
        } else if (c instanceof DeltaIterationBase.SolutionSetPlaceHolder) {
            if (this.parent == null) {
                throw new InvalidProgramException("It is currently not supported to create data sinks inside iterations.");
            }
            holder = (DeltaIterationBase.SolutionSetPlaceHolder)c;
            DeltaIterationBase enclosingIteration = holder.getContainingWorksetIteration();
            WorksetIterationNode containingIterationNode = (WorksetIterationNode)this.parent.con2node.get(enclosingIteration);
            SolutionSetNode p = new SolutionSetNode((DeltaIterationBase.SolutionSetPlaceHolder<?>)holder, containingIterationNode);
            p.setParallelism(containingIterationNode.getParallelism());
            n = p;
        } else {
            throw new IllegalArgumentException("Unknown operator type: " + c);
        }
        this.con2node.put(c, n);
        if (n.getParallelism() < 1) {
            int par = c.getParallelism();
            if (par > 0) {
                if (this.forceParallelism && par != this.defaultParallelism) {
                    par = this.defaultParallelism;
                    Optimizer.LOG.warn("The parallelism of nested dataflows (such as step functions in iterations) is currently fixed to the parallelism of the surrounding operator (the iteration).");
                }
            } else {
                par = this.defaultParallelism;
            }
            n.setParallelism(par);
        }
        return true;
    }

    public void postVisit(Operator<?> c) {
        OptimizerNode n = this.con2node.get(c);
        n.setInput(this.con2node, this.defaultDataExchangeMode);
        n.setBroadcastInputs(this.con2node, this.defaultDataExchangeMode);
        if (n instanceof BulkIterationNode) {
            BulkIterationNode iterNode = (BulkIterationNode)n;
            BulkIterationBase<?> iter = iterNode.getIterationContract();
            HashMap closure = new HashMap(this.con2node);
            GraphCreatingVisitor recursiveCreator = new GraphCreatingVisitor(this, true, iterNode.getParallelism(), this.defaultDataExchangeMode, closure);
            iter.getNextPartialSolution().accept((Visitor)recursiveCreator);
            BulkPartialSolutionNode partialSolution = (BulkPartialSolutionNode)recursiveCreator.con2node.get(iter.getPartialSolution());
            OptimizerNode rootOfStepFunction = recursiveCreator.con2node.get(iter.getNextPartialSolution());
            if (partialSolution == null) {
                throw new CompilerException("Error: The step functions result does not depend on the partial solution.");
            }
            OptimizerNode terminationCriterion = null;
            if (iter.getTerminationCriterion() != null && (terminationCriterion = recursiveCreator.con2node.get(iter.getTerminationCriterion())) == null) {
                iter.getTerminationCriterion().accept((Visitor)recursiveCreator);
                terminationCriterion = recursiveCreator.con2node.get(iter.getTerminationCriterion());
            }
            iterNode.setPartialSolution(partialSolution);
            iterNode.setNextPartialSolution(rootOfStepFunction, terminationCriterion);
            StaticDynamicPathIdentifier identifier = new StaticDynamicPathIdentifier(iterNode.getCostWeight());
            iterNode.acceptForStepFunction(identifier);
        } else if (n instanceof WorksetIterationNode) {
            WorksetIterationNode iterNode = (WorksetIterationNode)n;
            DeltaIterationBase<?, ?> iter = iterNode.getIterationContract();
            StepFunctionValidator wsf = new StepFunctionValidator();
            iter.getNextWorkset().accept((Visitor)wsf);
            if (!wsf.hasFoundWorkset()) {
                throw new CompilerException("In the given program, the next workset does not depend on the workset. This is a prerequisite in delta iterations.");
            }
            HashMap closure = new HashMap(this.con2node);
            GraphCreatingVisitor recursiveCreator = new GraphCreatingVisitor(this, true, iterNode.getParallelism(), this.defaultDataExchangeMode, closure);
            iter.getSolutionSetDelta().accept((Visitor)recursiveCreator);
            WorksetNode worksetNode = (WorksetNode)recursiveCreator.con2node.get(iter.getWorkset());
            if (worksetNode == null) {
                throw new CompilerException("In the given program, the solution set delta does not depend on the workset.This is a prerequisite in delta iterations.");
            }
            iter.getNextWorkset().accept((Visitor)recursiveCreator);
            SolutionSetNode solutionSetNode = (SolutionSetNode)recursiveCreator.con2node.get(iter.getSolutionSet());
            if (solutionSetNode == null || solutionSetNode.getOutgoingConnections() == null || solutionSetNode.getOutgoingConnections().isEmpty()) {
                solutionSetNode = new SolutionSetNode((DeltaIterationBase.SolutionSetPlaceHolder)iter.getSolutionSet(), iterNode);
            } else {
                for (DagConnection conn : solutionSetNode.getOutgoingConnections()) {
                    OptimizerNode successor = conn.getTarget();
                    if (successor.getClass() == JoinNode.class) {
                        JoinNode mn = (JoinNode)successor;
                        if (mn.getFirstPredecessorNode() == solutionSetNode) {
                            mn.makeJoinWithSolutionSet(0);
                            continue;
                        }
                        if (mn.getSecondPredecessorNode() == solutionSetNode) {
                            mn.makeJoinWithSolutionSet(1);
                            continue;
                        }
                        throw new CompilerException();
                    }
                    if (successor.getClass() == CoGroupNode.class) {
                        CoGroupNode cg = (CoGroupNode)successor;
                        if (cg.getFirstPredecessorNode() == solutionSetNode) {
                            cg.makeCoGroupWithSolutionSet(0);
                            continue;
                        }
                        if (cg.getSecondPredecessorNode() == solutionSetNode) {
                            cg.makeCoGroupWithSolutionSet(1);
                            continue;
                        }
                        throw new CompilerException();
                    }
                    throw new InvalidProgramException("Error: The only operations allowed on the solution set are Join and CoGroup.");
                }
            }
            OptimizerNode nextWorksetNode = recursiveCreator.con2node.get(iter.getNextWorkset());
            OptimizerNode solutionSetDeltaNode = recursiveCreator.con2node.get(iter.getSolutionSetDelta());
            iterNode.setPartialSolution(solutionSetNode, worksetNode);
            iterNode.setNextPartialSolution(solutionSetDeltaNode, nextWorksetNode, this.defaultDataExchangeMode);
            StaticDynamicPathIdentifier pathIdentifier = new StaticDynamicPathIdentifier(iterNode.getCostWeight());
            iterNode.acceptForStepFunction(pathIdentifier);
        }
    }
}

