/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.operators.CoGroupDescriptor;
import org.apache.flink.optimizer.operators.CoGroupWithSolutionSetFirstDescriptor;
import org.apache.flink.optimizer.operators.CoGroupWithSolutionSetSecondDescriptor;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;

public class CoGroupNode
extends TwoInputNode {
    private List<OperatorDescriptorDual> dataProperties;

    public CoGroupNode(CoGroupOperatorBase<?, ?, ?, ?> operator) {
        super((DualInputOperator<?, ?, ?, ?>)operator);
        this.dataProperties = this.initializeDataProperties(operator.getCustomPartitioner());
    }

    public CoGroupOperatorBase<?, ?, ?, ?> getOperator() {
        return (CoGroupOperatorBase)super.getOperator();
    }

    @Override
    public String getName() {
        return "CoGroup";
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return this.dataProperties;
    }

    public void makeCoGroupWithSolutionSet(int solutionsetInputIndex) {
        CoGroupDescriptor op;
        if (solutionsetInputIndex == 0) {
            op = new CoGroupWithSolutionSetFirstDescriptor(this.keys1, this.keys2);
        } else if (solutionsetInputIndex == 1) {
            op = new CoGroupWithSolutionSetSecondDescriptor(this.keys1, this.keys2);
        } else {
            throw new IllegalArgumentException();
        }
        this.dataProperties = Collections.singletonList(op);
    }

    @Override
    protected SemanticProperties getSemanticPropertiesForLocalPropertyFiltering() {
        int t;
        Iterator iterator;
        FieldSet targets;
        int f;
        DualInputSemanticProperties origProps = this.getOperator().getSemanticProperties();
        DualInputSemanticProperties filteredProps = new DualInputSemanticProperties();
        FieldSet readSet1 = origProps.getReadFields(0);
        FieldSet readSet2 = origProps.getReadFields(1);
        if (readSet1 != null) {
            filteredProps.addReadFields(0, readSet1);
        }
        if (readSet2 != null) {
            filteredProps.addReadFields(1, readSet2);
        }
        Iterator iterator2 = this.keys1.iterator();
        while (iterator2.hasNext()) {
            f = (Integer)iterator2.next();
            targets = origProps.getForwardingTargetFields(0, f);
            iterator = targets.iterator();
            while (iterator.hasNext()) {
                t = (Integer)iterator.next();
                filteredProps.addForwardedField(0, f, t);
            }
        }
        iterator2 = this.keys2.iterator();
        while (iterator2.hasNext()) {
            f = (Integer)iterator2.next();
            targets = origProps.getForwardingTargetFields(1, f);
            iterator = targets.iterator();
            while (iterator.hasNext()) {
                t = (Integer)iterator.next();
                filteredProps.addForwardedField(1, f, t);
            }
        }
        return filteredProps;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    private List<OperatorDescriptorDual> initializeDataProperties(Partitioner<?> customPartitioner) {
        Ordering groupOrder1 = null;
        Ordering groupOrder2 = null;
        CoGroupOperatorBase<?, ?, ?, ?> cgc = this.getOperator();
        groupOrder1 = cgc.getGroupOrderForInputOne();
        groupOrder2 = cgc.getGroupOrderForInputTwo();
        if (groupOrder1 != null && groupOrder1.getNumberOfFields() == 0) {
            groupOrder1 = null;
        }
        if (groupOrder2 != null && groupOrder2.getNumberOfFields() == 0) {
            groupOrder2 = null;
        }
        CoGroupDescriptor descr = new CoGroupDescriptor(this.keys1, this.keys2, groupOrder1, groupOrder2);
        if (customPartitioner != null) {
            descr.setCustomPartitioner(customPartitioner);
        }
        return Collections.singletonList(descr);
    }
}

